% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_assessment.R
\name{rl_assessment_extract}
\alias{rl_assessment_extract}
\title{Extract an assessment element}
\usage{
rl_assessment_extract(lst, el_name, format = c("list", "df"), flatten = FALSE)
}
\arguments{
\item{lst}{(list) A list of assessments, as returned by
\code{\link[=rl_assessment_list]{rl_assessment_list()}}. If \code{lst} contains any \code{NULL} elements, they will be
removed.}

\item{el_name}{(character) The name of the element to extract from each
assessment. Supports multilevel extraction using "__" as the separator. For
example, to extract the synonyms table, you could use "taxon__synonyms".}

\item{format}{(character) The format of the output. Either "list" or "df"
(for a data.frame).}

\item{flatten}{(logical) If \code{TRUE}, the output will be flattened to a
data.frame. Note that this may not work for all elements, especially
complex multilevel list elements. Only used when \code{format = "df"}. The
\code{dplyr}, \code{tidyr}, and \code{tibble} packages are required to use this feature.
Note that fields with no data across all assessments may be lost.}
}
\value{
A list or data.frame containing the extracted element from each
assessment.
}
\description{
Extract a given element from each of a list of assessments, such as the
output of \code{\link[=rl_assessment_list]{rl_assessment_list()}}. This is useful for extracting specific
details from the assessments, such as taxonomy (\code{el_name = "taxon"}),
synonyms (\code{el_name = "taxon__synonyms"}), habitats (\code{el_name = "habitats"}),
or the red list category (\code{el_name = "red_list_category"}).
}
\details{
The following top-level element names can be extracted as of
2025-07-27:
\itemize{
\item assessment_date
\item assessment_id
\item assessment_points
\item assessment_ranges
\item biogeographical_realms
\item citation
\item conservation_actions
\item credits
\item criteria
\item documentation
\item errata
\item faos
\item growth_forms
\item habitats
\item latest
\item lmes
\item locations
\item population_trend
\item possibly_extinct
\item possibly_extinct_in_the_wild
\item red_list_category
\item references
\item researches
\item scopes
\item sis_taxon_id
\item stresses
\item supplementary_info
\item systems
\item taxon
\item threats
\item url
\item use_and_trade
\item year_published
}

Note that there are also sublevels of the assessment hierarchy, but they
would be unwieldy to display here. A complete and up-to-date list can be
found by inspecting the return of an \code{\link[=rl_assessment]{rl_assessment()}} call.
}
\examples{
\dontrun{
lst <- rl_assessment_list(ids = c(166290968, 136250858))
# get complex elements as a list
ex1 <- rl_assessment_extract(lst, "taxon")
# get simple elements as a data.frame
ex2 <- rl_assessment_extract(lst, "red_list_category__code", format = "df")
# get complex elements as a data.frame
ex3 <- rl_assessment_extract(lst, "threats", format = "df")
# get the same elements flattened to a single data.frame
ex4 <- rl_assessment_extract(lst, "threats", format = "df", flatten = TRUE)
# get subelements flattened to a data.frame
ex5 <- rl_assessment_extract(lst, "taxon__order_name", format = "df",
                             flatten = TRUE)
# get a data frame with taxon name and red list category code
ex6 <- merge(
 rl_assessment_extract(lst, "taxon", format = "df", flatten = TRUE),
 rl_assessment_extract(lst, "red_list_category__code", format = "df"),
 by = "assessment_id"
)
}
}
