% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regbar.R
\name{regbar}
\alias{regbar}
\title{Barplot with explicit data comparison}
\usage{
regbar(data, x, y, comp, num, aim = NULL, split = NULL, ascending = TRUE,
  title, ylab, col1, col2, col3, flip = TRUE, ...)
}
\arguments{
\item{data}{Data set}

\item{x}{x-axis}

\item{y}{y-axis}

\item{comp}{Compare a specific bar from the rest for a vivid comparison
eg. National compared to the different districts}

\item{num}{Include denominator i.e N in the figure eg. Tawau HF (N=2088)}

\item{aim}{A line on y-axis indicating aim}

\item{split}{Where to split inside and outside text eg. 10\% of max as split=0.1}

\item{ascending}{Sort data ascending order}

\item{title}{Title for the plot}

\item{ylab}{Label for y-axis}

\item{col1}{Color for bars}

\item{col2}{Color for the 'diff' bar}

\item{col3}{Color for aim line}

\item{flip}{Flip plot horizontally}

\item{...}{Additional arguments}
}
\description{
Create a barplot with the posibility to differentiate a specific item compared to
the rest. This is useful in a situation when there is a need to show the total
value as compared to each items in the x-axis. A specific example related to the
Norwegian Health Registries is when the aggregated value from each health
institutions or health regions is compared to the national data.
}
\examples{
# basic usage
library("rreg")
regbar(data = hfdata, x = inst, y = case2)
regbar(hfdata, inst, case2, comp = "Tawau HF")
regbar(hfdata, inst, 2007, comp = "Taw", num = extt)

# split text visualisatio at 5\% of max value
regbar(hfdata, inst, 2007, comp = "Taw", split = 0.05)

}
