% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_ibd.R
\name{ibd.segment}
\alias{ibd.segment}
\title{Score IBD sharing by segment.}
\usage{
ibd.segment(inheritance, ind1index, ind2index = NULL, relatedness = TRUE)
}
\arguments{
\item{inheritance}{list of numeric matrices.}

\item{ind1index, ind2index}{positive integer, represents index of individual in pedigree.}

\item{relatedness}{logical, determines coding of IBD information.}
}
\value{
A dataframe of three variables. \code{ibd} represents IBD sharing status of a segment, and \code{startpos}/\code{endpos} represents starting/ending genetic position of the segment.
}
\description{
\code{ibd.segment} determines the starting and endping genetic positions of segments with different amount of pairwise IBD sharing.
}
\details{
When only index of one individual is supplied, IBD sharing status for each segment is coded as 0 (not IBD) or 1 (IBD) between the two haplotypes of the individual.

When indices of two individuals are supplied, IBD sharing status for each segment is either in relatedness (default) or alphanumeric IBD state, where recoding can be done using \code{\link{recode.ibd}}.
}
\examples{
# a simple pedigree with sibling marriage
pedigree = as.character(rep(1, 5))
member = as.character(c(11, 12, 21, 22, 31))
sex = as.numeric(c(1, 2, 1, 2, 1))
father = as.character(c(NA, NA, 11, 11, 21))
mother = as.character(c(NA, NA, 12, 12, 22))
pedinfo = data.frame(pedigree, member, sex, father, mother, stringsAsFactors = FALSE)
inheritance = sim.recomb(pedinfo, 100)

# IBD segments between the two haplotypes of the inbred individual
ibd.segment(inheritance, 5)

# IBD segments between the two full sibs
ibd.segment(inheritance, 3, 4) # relatedness
ibd.segment(inheritance, 3, 4, relatedness = FALSE) # alphanumeric IBD state
}
