% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.R
\name{bootstraps}
\alias{bootstraps}
\title{Bootstrap Sampling}
\usage{
bootstraps(data, times = 25, strata = NULL, apparent = FALSE, ...)
}
\arguments{
\item{data}{A data frame.}

\item{times}{The number of bootstrap samples.}

\item{strata}{A variable that is used to conduct stratified sampling. When not `NULL`, each bootstrap sample is created within the stratification variable.}

\item{apparent}{A logical. Should an extra resample be added where the analysis and holdout subset are the entire data set. This is required for some estimators used by the `summary` function that require the apparent error rate.}

\item{...}{Not currently used.}
}
\value{
An tibble with classes `bootstraps`, `rset`, `tbl_df`, `tbl`, and `data.frame`. The results include a column for the data split objects and a column called `id` that has a character string with the resample identifier.
}
\description{
A bootstrap sample is a sample that is the same size as the original data set that is made using replacement.  This results in analysis samples that have multiple replicates of some of the original rows of the data. The assessment set is defined as the rows of the original data that were not included in the bootstrap sample. This is often referred to as the "out-of-bag" (OOB) sample.
}
\details{
The argument `apparent` enables the option of an additional "resample" where the analysis and assessment data sets are the same as the original data set. This can be required for some types of analysis of the bootstrap results. 

The `strata` argument is based on a similar argument in the random forest package were the bootstrap samples are conducted *within the stratification variable*. The can help ensure that the number of data points in the bootstrap sample is equivalent to the proportions in the original data set.
}
\examples{
bootstraps(mtcars, times = 2)
bootstraps(mtcars, times = 2, apparent = TRUE)

library(purrr)
iris2 <- iris[1:130, ]

set.seed(13)
resample1 <- bootstraps(iris2, times = 3)
map_dbl(resample1$splits,
        function(x) {
          dat <- as.data.frame(x)$Species
          mean(dat == "virginica")
        })

set.seed(13)
resample2 <- bootstraps(iris2, strata = "Species", times = 3)
map_dbl(resample2$splits,
        function(x) {
          dat <- as.data.frame(x)$Species
          mean(dat == "virginica")
        })
}
