% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtoi.R
\name{records}
\alias{records}
\alias{records,rtoi-method}
\alias{records,rtoi}
\alias{records<-}
\alias{records<-,rtoi,records-method}
\alias{records<-,rtoi,records}
\title{Extracts the satellite records}
\usage{
records(x)

\S4method{records}{rtoi}(x)

records(x) <- value

\S4method{records}{rtoi,records}(x) <- value
}
\arguments{
\item{x}{an rtoi object}

\item{value}{a records object to be set to x.}
}
\value{
a set of records in x rtoi
}
\description{
returns the object records from an rtoi.
}
\examples{
#' library(rsat)
# create a copy of navarre
file.copy(from=system.file("ex/Navarre",package="rsat"),
         to=tempdir(),
         recursive = TRUE)
# load example rtoi
navarre <- read_rtoi(file.path(tempdir(),"Navarre"))
print(navarre)

rcrds <- records(navarre)

records(navarre)<-rcrds[1]
print(navarre)

records(navarre) <- rcrds
print(navarre)
unlink(file.path(tempdir(),"Navarre"),recursive=TRUE)
}
