/*
 * Decompiled with CFR 0.152.
 */
package scala;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.text.MessageFormat;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.DynamicVariable;

public final class Console$ {
    public static final Console$ MODULE$;
    private final String BLACK;
    private final String RED;
    private final String GREEN;
    private final String YELLOW;
    private final String BLUE;
    private final String MAGENTA;
    private final String CYAN;
    private final String WHITE;
    private final String BLACK_B;
    private final String RED_B;
    private final String GREEN_B;
    private final String YELLOW_B;
    private final String BLUE_B;
    private final String MAGENTA_B;
    private final String CYAN_B;
    private final String WHITE_B;
    private final String RESET;
    private final String BOLD;
    private final String UNDERLINED;
    private final String BLINK;
    private final String REVERSED;
    private final String INVISIBLE;
    private final ByteArrayOutputStream baosOut;
    private final ByteArrayOutputStream baosErr;
    private final PrintStream psOut;
    private final PrintStream psErr;
    private final PrintStream originalOut;
    private final PrintStream originalErr;
    private final DynamicVariable<PrintStream> outVar;
    private final DynamicVariable<PrintStream> errVar;
    private final DynamicVariable<BufferedReader> inVar;

    static {
        new Console$();
    }

    public final String BLACK() {
        return "\u001b[30m";
    }

    public final String RED() {
        return "\u001b[31m";
    }

    public final String GREEN() {
        return "\u001b[32m";
    }

    public final String YELLOW() {
        return "\u001b[33m";
    }

    public final String BLUE() {
        return "\u001b[34m";
    }

    public final String MAGENTA() {
        return "\u001b[35m";
    }

    public final String CYAN() {
        return "\u001b[36m";
    }

    public final String WHITE() {
        return "\u001b[37m";
    }

    public final String BLACK_B() {
        return "\u001b[40m";
    }

    public final String RED_B() {
        return "\u001b[41m";
    }

    public final String GREEN_B() {
        return "\u001b[42m";
    }

    public final String YELLOW_B() {
        return "\u001b[43m";
    }

    public final String BLUE_B() {
        return "\u001b[44m";
    }

    public final String MAGENTA_B() {
        return "\u001b[45m";
    }

    public final String CYAN_B() {
        return "\u001b[46m";
    }

    public final String WHITE_B() {
        return "\u001b[47m";
    }

    public final String RESET() {
        return "\u001b[0m";
    }

    public final String BOLD() {
        return "\u001b[1m";
    }

    public final String UNDERLINED() {
        return "\u001b[4m";
    }

    public final String BLINK() {
        return "\u001b[5m";
    }

    public final String REVERSED() {
        return "\u001b[7m";
    }

    public final String INVISIBLE() {
        return "\u001b[8m";
    }

    public ByteArrayOutputStream baosOut() {
        return this.baosOut;
    }

    public ByteArrayOutputStream baosErr() {
        return this.baosErr;
    }

    public PrintStream psOut() {
        return this.psOut;
    }

    public PrintStream psErr() {
        return this.psErr;
    }

    public PrintStream originalOut() {
        return this.originalOut;
    }

    public PrintStream originalErr() {
        return this.originalErr;
    }

    private DynamicVariable<PrintStream> outVar() {
        return this.outVar;
    }

    private DynamicVariable<PrintStream> errVar() {
        return this.errVar;
    }

    private DynamicVariable<BufferedReader> inVar() {
        return this.inVar;
    }

    public PrintStream out() {
        return (PrintStream)this.outVar().value();
    }

    public PrintStream err() {
        return (PrintStream)this.errVar().value();
    }

    public BufferedReader in() {
        return (BufferedReader)this.inVar().value();
    }

    public void setOut(PrintStream out) {
        this.outVar().value_$eq((Object)out);
    }

    public <T> T withOut(PrintStream out, Function0<T> thunk) {
        return (T)this.outVar().withValue((Object)out, thunk);
    }

    public void setOut(OutputStream out) {
        this.setOut(new PrintStream(out));
    }

    public <T> T withOut(OutputStream out, Function0<T> thunk) {
        return this.withOut(new PrintStream(out), thunk);
    }

    public void setErr(PrintStream err) {
        this.errVar().value_$eq((Object)err);
    }

    public <T> T withErr(PrintStream err, Function0<T> thunk) {
        return (T)this.errVar().withValue((Object)err, thunk);
    }

    public void setErr(OutputStream err) {
        this.setErr(new PrintStream(err));
    }

    public <T> T withErr(OutputStream err, Function0<T> thunk) {
        return this.withErr(new PrintStream(err), thunk);
    }

    public void setIn(Reader reader) {
        this.inVar().value_$eq((Object)new BufferedReader(reader));
    }

    public <T> T withIn(Reader reader, Function0<T> thunk) {
        return (T)this.inVar().withValue((Object)new BufferedReader(reader), thunk);
    }

    public void setIn(InputStream in) {
        this.setIn(new InputStreamReader(in));
    }

    public <T> T withIn(InputStream in, Function0<T> thunk) {
        return this.withIn(new InputStreamReader(in), thunk);
    }

    public void print(Object obj) {
        this.out().print(obj == null ? "null" : obj.toString());
    }

    public void flush() {
        this.out().flush();
    }

    public void println() {
        this.out().println();
    }

    public void println(Object x) {
        this.out().println(x);
    }

    public void printf(String text, Seq<Object> args) {
        this.out().print(new StringOps(Predef$.MODULE$.augmentString(text)).format(args));
    }

    public String readLine() {
        return this.in().readLine();
    }

    public String readLine(String text, Seq<Object> args) {
        this.printf(text, args);
        return this.readLine();
    }

    public boolean readBoolean() {
        boolean bl;
        String string;
        String s = this.readLine();
        if (s == null) {
            throw new EOFException("Console has reached end of input");
        }
        String string2 = string = s.toLowerCase();
        if (!("true" != null ? !"true".equals(string2) : string2 != null)) {
            bl = true;
        } else {
            String string3 = string;
            if (!("t" != null ? !"t".equals(string3) : string3 != null)) {
                bl = true;
            } else {
                String string4 = string;
                if (!("yes" != null ? !"yes".equals(string4) : string4 != null)) {
                    bl = true;
                } else {
                    String string5 = string;
                    bl = !("y" != null ? !"y".equals(string5) : string5 != null);
                }
            }
        }
        return bl;
    }

    public byte readByte() {
        String s = this.readLine();
        if (s == null) {
            throw new EOFException("Console has reached end of input");
        }
        return new StringOps(Predef$.MODULE$.augmentString(s)).toByte();
    }

    public short readShort() {
        String s = this.readLine();
        if (s == null) {
            throw new EOFException("Console has reached end of input");
        }
        return new StringOps(Predef$.MODULE$.augmentString(s)).toShort();
    }

    public char readChar() {
        String s = this.readLine();
        if (s == null) {
            throw new EOFException("Console has reached end of input");
        }
        return s.charAt(0);
    }

    public int readInt() {
        String s = this.readLine();
        if (s == null) {
            throw new EOFException("Console has reached end of input");
        }
        return new StringOps(Predef$.MODULE$.augmentString(s)).toInt();
    }

    public long readLong() {
        String s = this.readLine();
        if (s == null) {
            throw new EOFException("Console has reached end of input");
        }
        return new StringOps(Predef$.MODULE$.augmentString(s)).toLong();
    }

    public float readFloat() {
        String s = this.readLine();
        if (s == null) {
            throw new EOFException("Console has reached end of input");
        }
        return new StringOps(Predef$.MODULE$.augmentString(s)).toFloat();
    }

    public double readDouble() {
        String s = this.readLine();
        if (s == null) {
            throw new EOFException("Console has reached end of input");
        }
        return new StringOps(Predef$.MODULE$.augmentString(s)).toDouble();
    }

    public List<Object> readf(String format) {
        String s = this.readLine();
        if (s == null) {
            throw new EOFException("Console has reached end of input");
        }
        return this.textComponents(new MessageFormat(format).parse(s));
    }

    public Object readf1(String format) {
        return this.readf(format).head();
    }

    public Tuple2<Object, Object> readf2(String format) {
        List<Object> res = this.readf(format);
        return new Tuple2(res.head(), ((IterableLike)res.tail()).head());
    }

    public Tuple3<Object, Object, Object> readf3(String format) {
        List<Object> res = this.readf(format);
        return new Tuple3(res.head(), ((IterableLike)res.tail()).head(), ((IterableLike)((TraversableLike)res.tail()).tail()).head());
    }

    /*
     * WARNING - void declaration
     */
    private List<Object> textComponents(Object[] a) {
        void var3_3;
        Nil$ res = Nil$.MODULE$;
        for (int i = a.length - 1; i >= 0; --i) {
            Object object;
            Object object2 = a[i];
            if (object2 instanceof Boolean) {
                Boolean bl = (Boolean)object2;
                object = BoxesRunTime.boxToBoolean((boolean)bl);
            } else if (object2 instanceof Byte) {
                Byte by = (Byte)object2;
                object = BoxesRunTime.boxToByte((byte)by);
            } else if (object2 instanceof Short) {
                Short s = (Short)object2;
                object = BoxesRunTime.boxToShort((short)s);
            } else if (object2 instanceof Character) {
                Character c = (Character)object2;
                object = BoxesRunTime.boxToCharacter((char)c.charValue());
            } else if (object2 instanceof Integer) {
                Integer n = (Integer)object2;
                object = BoxesRunTime.boxToInteger((int)n);
            } else if (object2 instanceof Long) {
                Long l = (Long)object2;
                object = BoxesRunTime.boxToLong((long)l);
            } else if (object2 instanceof Float) {
                Float f = (Float)object2;
                object = BoxesRunTime.boxToFloat((float)f.floatValue());
            } else if (object2 instanceof Double) {
                Double d = (Double)object2;
                object = BoxesRunTime.boxToDouble((double)d);
            } else {
                object = object2;
            }
            Boolean bl = object;
            res = res.$colon$colon((Object)bl);
        }
        return var3_3;
    }

    private Console$() {
        MODULE$ = this;
        this.baosOut = new ByteArrayOutputStream();
        this.baosErr = new ByteArrayOutputStream();
        this.psOut = new PrintStream(this.baosOut(), true);
        this.psErr = new PrintStream(this.baosErr(), true);
        this.originalOut = System.out;
        this.originalErr = System.err;
        try {
            Object object = package$.MODULE$.env().apply((Object)"RSCALA_TUNNELING");
            String string = "TRUE";
            if (!(object != null ? !object.equals(string) : string != null)) {
                System.setOut(this.psOut());
                System.setErr(this.psErr());
            }
        }
        catch (Throwable throwable) {}
        this.outVar = new DynamicVariable((Object)System.out);
        this.errVar = new DynamicVariable((Object)System.err);
        this.inVar = new DynamicVariable((Object)new BufferedReader(new InputStreamReader(System.in)));
    }
}

