% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalaDevelDownloadJARs.R
\name{scalaDevelDownloadJARs}
\alias{scalaDevelDownloadJARs}
\title{Download and Deploy JAR Files into the Package File System}
\usage{
scalaDevelDownloadJARs(description, scalaMajorVersion = "",
  prefix = "https://search.maven.org/remotecontent?filepath=")
}
\arguments{
\item{description}{A character vector describing the JAR files to download,
e,g. \code{"org.apache.commons:commons-math3:3.6.1"}.}

\item{scalaMajorVersion}{A Scala major version, such as \code{"2.13"}, if the
JAR should be placed in a directory specific to a Scala version. Otherwise,
\code{""} is used to specify a general installation.}

\item{prefix}{A string giving the prefix of the download URL.}
}
\description{
This function only takes effect during package installation. It is meant to
be called from bare code of a package that depends on \pkg{rscala} in a
script such as \code{zzz.R}. When called during package installation, it
downloads JAR files to the appropriate directories.  This avoids the need to
distribute some JAR files in the source package.
}
\examples{
\dontrun{
## To be run in bare code of a package that depends on rscala and needs,
## for example, the Apache Commons Math Library.
rscala::scalaDevelDownloadJARs("org.apache.commons:commons-math3:3.6.1")
}

}
