/*
 * Decompiled with CFR 0.152.
 */
package org.ddahl.rscala.server;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.ddahl.rscala.server.Debugger;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.sys.package$;
import scala.util.Properties$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ea\u0001\u0002\u000e\u001c\u0001\u0011B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\ta\u0001\u0011\t\u0011)A\u0005[!A\u0011\u0007\u0001BC\u0002\u0013\u0005!\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00034\u0011!9\u0004A!b\u0001\n\u0003A\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u000by\u0002A\u0011A \t\u0015\u0011\u0003\u0001\u0013!A\u0002B\u0003%Q\tC\u0004I\u0001\t\u0007I\u0011\u0002\u0017\t\r%\u0003\u0001\u0015!\u0003.\u0011\u001dQ\u0005A1A\u0005\n1Baa\u0013\u0001!\u0002\u0013i\u0003b\u0002'\u0001\u0005\u0004%I!\u0014\u0005\u0007-\u0002\u0001\u000b\u0011\u0002(\t\u000f]\u0003!\u0019!C\u00051\"1A\f\u0001Q\u0001\neCq!\u0018\u0001C\u0002\u0013%\u0001\f\u0003\u0004_\u0001\u0001\u0006I!\u0017\u0005\b?\u0002\u0011\r\u0011\"\u0001-\u0011\u0019\u0001\u0007\u0001)A\u0005[!9\u0011\r\u0001b\u0001\n\u0003a\u0003B\u00022\u0001A\u0003%Q\u0006C\u0003d\u0001\u0011\u0005A\rC\u0003q\u0001\u0011\u0005\u0011\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0002\b'>\u001c7.\u001a;t\u0015\taR$\u0001\u0004tKJ4XM\u001d\u0006\u0003=}\taA]:dC2\f'B\u0001\u0011\"\u0003\u0015!G-\u00195m\u0015\u0005\u0011\u0013aA8sO\u000e\u00011C\u0001\u0001&!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0019\te.\u001f*fM\u0006!\u0001o\u001c:u+\u0005i\u0003C\u0001\u0014/\u0013\tysEA\u0002J]R\fQ\u0001]8si\u0002\naAY;gM\u0016\u0014X#A\u001a\u0011\u0005\u0019\"\u0014BA\u001b(\u0005\u001d\u0011un\u001c7fC:\fqAY;gM\u0016\u0014\b%\u0001\u0005eK\n,xmZ3s+\u0005I\u0004C\u0001\u001e<\u001b\u0005Y\u0012B\u0001\u001f\u001c\u0005!!UMY;hO\u0016\u0014\u0018!\u00033fEV<w-\u001a:!\u0003\u0019a\u0014N\\5u}Q!\u0001)\u0011\"D!\tQ\u0004\u0001C\u0003,\u000f\u0001\u0007Q\u0006C\u00032\u000f\u0001\u00071\u0007C\u00038\u000f\u0001\u0007\u0011(A\u0002yIE\u0002BA\n$.[%\u0011qi\n\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u000fA|'\u000f^*3%\u0006A\u0001o\u001c:u'J\u0012\u0006%A\u0004q_J$(KM*\u0002\u0011A|'\u000f\u001e*3'\u0002\n\u0011\u0002\\8dC2Dwn\u001d;\u0016\u00039\u0003\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\u00079,GOC\u0001T\u0003\u0011Q\u0017M^1\n\u0005U\u0003&aC%oKR\fE\r\u001a:fgN\f!\u0002\\8dC2Dwn\u001d;!\u0003%\u0019XM\u001d<fe>+H/F\u0001Z!\ty%,\u0003\u0002\\!\na1+\u001a:wKJ\u001cvnY6fi\u0006Q1/\u001a:wKJ|U\u000f\u001e\u0011\u0002\u0011M,'O^3s\u0013:\f\u0011b]3sm\u0016\u0014\u0018J\u001c\u0011\u0002\u000f=,H\u000fU8si\u0006Aq.\u001e;Q_J$\b%\u0001\u0004j]B{'\u000f^\u0001\bS:\u0004vN\u001d;!\u0003\r\u0001\u0018\u000eZ\u000b\u0002KB\u0011a-\u001c\b\u0003O.\u0004\"\u0001[\u0014\u000e\u0003%T!A[\u0012\u0002\rq\u0012xn\u001c;?\u0013\taw%\u0001\u0004Qe\u0016$WMZ\u0005\u0003]>\u0014aa\u0015;sS:<'B\u00017(\u000399(/\u001b;f!>\u0014Ho\u001d$jY\u0016$2A];x!\t13/\u0003\u0002uO\t!QK\\5u\u0011\u00151\b\u00041\u0001f\u00035\u0001xN\u001d;t\r&dWM\\1nK\")\u0001\u0010\u0007a\u0001s\u0006Y\u0001O]5oi^\u0013\u0018\u000e^3s!\tQX0D\u0001|\u0015\ta(+\u0001\u0002j_&\u0011ap\u001f\u0002\f!JLg\u000e^,sSR,'/\u0001\bbG\u000e,\u0007\u000f^!oIN+G/\u001e9\u0015\u0005\u0005\r\u0001C\u0002\u0014G\u0003\u000b\tY\u0001E\u0002{\u0003\u000fI1!!\u0003|\u0005A!\u0015\r^1PkR\u0004X\u000f^*ue\u0016\fW\u000eE\u0002{\u0003\u001bI1!a\u0004|\u0005=!\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0007")
public class Sockets {
    private final int port;
    private final boolean buffer;
    private final Debugger debugger;
    private final /* synthetic */ Tuple2 x$1;
    private final int portS2R;
    private final int portR2S;
    private final InetAddress localhost;
    private final ServerSocket serverOut;
    private final ServerSocket serverIn;
    private final int outPort;
    private final int inPort;

    public int port() {
        return this.port;
    }

    public boolean buffer() {
        return this.buffer;
    }

    public Debugger debugger() {
        return this.debugger;
    }

    private int portS2R() {
        return this.portS2R;
    }

    private int portR2S() {
        return this.portR2S;
    }

    private InetAddress localhost() {
        return this.localhost;
    }

    private ServerSocket serverOut() {
        return this.serverOut;
    }

    private ServerSocket serverIn() {
        return this.serverIn;
    }

    public int outPort() {
        return this.outPort;
    }

    public int inPort() {
        return this.inPort;
    }

    public String pid() {
        String tmp;
        String string;
        File selfFile = new File("/proc/self");
        if (selfFile.exists() && !Properties$.MODULE$.isWin() && !Properties$.MODULE$.isMac()) {
            return Sockets.ensureLong$1(selfFile.getCanonicalFile().getName(), Sockets.ensureLong$default$2$1());
        }
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int n = jvmName.indexOf("@");
        switch (n) {
            case -1: {
                string = "-1";
                break;
            }
            default: {
                string = Sockets.ensureLong$1(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(jvmName), n), Sockets.ensureLong$default$2$1());
                break;
            }
        }
        String string2 = tmp = string;
        String string3 = "-1";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null) && Properties$.MODULE$.isMac()) {
            return Sockets.ensureLong$1(scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)new .colon.colon((Object)"sh", (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)"echo $PPID", (List)Nil$.MODULE$)))).$bang$bang().trim(), Sockets.ensureLong$default$2$1());
        }
        return tmp;
    }

    public void writePortsFile(String portsFilename, PrintWriter printWriter) {
        try {
            File portsFile = new File(portsFilename);
            PrintWriter p = new PrintWriter(portsFile);
            p.println(new StringBuilder(2).append(this.outPort()).append(" ").append(this.inPort()).append(" ").append(this.pid()).toString());
            p.close();
        }
        catch (Throwable e) {
            if (this.debugger().on()) {
                printWriter.println(e);
                e.printStackTrace(printWriter);
                this.debugger().apply("cannot write to ports file, exiting...");
            }
            throw package$.MODULE$.exit(0);
        }
    }

    public Tuple2<DataOutputStream, DataInputStream> acceptAndSetup() {
        if (this.debugger().on()) {
            this.debugger().apply(new StringBuilder(39).append("socket S2R waiting for client on port ").append(this.serverOut().getLocalPort()).append(".").toString());
        }
        Socket sOut = this.serverOut().accept();
        if (this.debugger().on()) {
            this.debugger().apply(new StringBuilder(39).append("socket R2S waiting for client on port ").append(this.serverIn().getLocalPort()).append(".").toString());
        }
        Socket sIn = this.serverIn().accept();
        OutputStream bos = this.buffer() ? new BufferedOutputStream(sOut.getOutputStream()) : sOut.getOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        DataInputStream in = new DataInputStream(sIn.getInputStream());
        if (this.debugger().on()) {
            this.debugger().apply("connections established.");
        }
        return new Tuple2((Object)out, (Object)in);
    }

    private static final String ensureLong$1(String x, String fallback) {
        String string;
        try {
            string = Long.toString(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x)));
        }
        catch (Throwable throwable) {
            string = fallback;
        }
        return string;
    }

    private static final String ensureLong$default$2$1() {
        return "-1";
    }

    public Sockets(int port, boolean buffer, Debugger debugger) {
        Tuple2.mcII.sp sp2;
        this.port = port;
        this.buffer = buffer;
        this.debugger = debugger;
        if (debugger.on()) {
            debugger.apply("starting server.");
        }
        Tuple2.mcII.sp sp3 = sp2 = port == 0 ? new Tuple2.mcII.sp(0, 0) : new Tuple2.mcII.sp(port, port + 1);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int portS2R = sp2._1$mcI$sp();
        int portR2S = sp2._2$mcI$sp();
        this.x$1 = new Tuple2.mcII.sp(portS2R, portR2S);
        this.portS2R = this.x$1._1$mcI$sp();
        this.portR2S = this.x$1._2$mcI$sp();
        this.localhost = InetAddress.getByName(null);
        this.serverOut = new ServerSocket(this.portS2R(), 0, this.localhost());
        this.serverIn = new ServerSocket(this.portR2S(), 0, this.localhost());
        this.outPort = this.serverOut().getLocalPort();
        this.inPort = this.serverIn().getLocalPort();
    }
}

