% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/author_df.R
\name{author_df}
\alias{author_data}
\alias{author_df}
\title{Search Author Content on SCOPUS}
\usage{
author_df(au_id, last_name, first_name, api_key = NULL, verbose = TRUE,
  all_author_info = FALSE, ...)

author_data(au_id, last_name, first_name, api_key = NULL, verbose = TRUE,
  all_author_info = FALSE, ...)
}
\arguments{
\item{au_id}{Author ID number. Overrides any first/last name argument}

\item{last_name}{last name of author}

\item{first_name}{first name of author}

\item{api_key}{Elsvier API key}

\item{verbose}{Print diagnostic messages}

\item{all_author_info}{Should all author info be recorded instead of that just to the
author given}

\item{...}{Arguments to be passed to \code{\link{author_search}}}
}
\value{
List of entries from SCOPUS
}
\description{
Searches SCOPUS to get information about documents on an author.
}
\note{
The \code{author_data} command will return the list of all entries as well as
the \code{data.frame}.
}
\examples{
\dontrun{
author_df(last_name = "Muschelli", first_name = "John")
}
}
\seealso{
\code{\link{get_author_info}}
}

