% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass_adjuster.R
\name{mass_adjuster}
\alias{mass_adjuster}
\title{Mass adjuster}
\usage{
mass_adjuster(g, force = "force", resolution_limit = TRUE)
}
\arguments{
\item{g}{An igraph object. the network}

\item{force}{A character string. The name of the network attribute contain the network forces. Default is "force"}

\item{resolution_limit}{logical. If the forces in the network are smaller than the square root of the machine floating point limit
then the mass is set to one. default is true}
}
\value{
A numeric value giving the adjusted mass of the nodes in the network.
}
\description{
This function adjusts the mass of the nodes so that the force in each direction over the mass for that direction 
produces an acceleration of 1.
}
\details{
This function can help stabilise the convergence of networks by preventing major imbalances between the force in the network
and the mass of the nodes. in certain cases acceleration can become very large or very small in 
if force and mass are not well parametrised. 

This function means that if the network were reduced to two nodes where each node contained all the mass and all the force of
one of the two directions, then each node would have an acceleration of 1ms^-2

The function can become important when using SETSe_bicomp as the force mass ratio of biconnection components can vary widely from
the total force mass ratio of the network.
}
\examples{
set.seed(234) #set the random see for generating the network

g <- generate_peels_network(type = "E") \%>\%
prepare_SETSe_binary(., node_names = "name", k = 1000, 
                     force_var = "class", 
                     positive_value = "A")

mass_adjuster(g, force = "force", resolution_limit = TRUE)

}
