% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eeg.R
\name{spectrogram}
\alias{spectrogram}
\title{Plot the spectrogram of signal.}
\usage{
spectrogram(signal, sRate, maxFreq = 25, n = 1024, window = n * 2,
  overlap = 0, cols = c(rep("#3B9AB2", 9), "#78B7C5", "#EBCC2A",
  "#E1AF00", rep("#F21A00", 6)), freq = 4, plot = TRUE,
  startTime = as.POSIXct("1970/01/01 00:00:00"))
}
\arguments{
\item{signal}{Numerical vector of the signal.}

\item{sRate}{Signal sample rate in Hertz.}

\item{maxFreq}{Maximal frequency to plot in Hertz. Signal will be resampled at maxFreq*2 sample rate.}

\item{n}{The size of the Fourier transform window.}

\item{window}{Shape of the fourier transform window, defaults to n*2.}

\item{overlap}{Overlap with previous window, defaults to 0.}

\item{cols}{Color scale used for the underlying plot function.}

\item{freq}{Aggregate frequency used to lower spectrogram resolution. Defaults to 4.}

\item{plot}{Boolean, plot or not the spectrogram.}

\item{startTime}{Posixct of the signal start. Adjust the x axis labels accordingly.}
}
\value{
A spectrogram.
}
\description{
`spectrogram` resamples signal and use the `specgram` function from the `signal` library to compute the spectrogram. Results resolution can be then reduced to quickly plot large signals.
}
\examples{
library(signal)
spectrogram(chirp(seq(-2, 15, by = 0.001), 400, 10, 100, 'quadratic'),20,n=1024)
}
