% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{hypnogram}
\alias{hypnogram}
\title{Filter and reorder an events dataframe or a hypnodensity to keep only sleep stages related-events.}
\usage{
hypnogram(
  events,
  labels = c("N3", "N2", "N1", "REM", "AWA"),
  startTime = 946681200,
  epoch_duration = 30,
  plot = FALSE
)
}
\arguments{
\item{events}{Events dataframe. Dataframe must have \code{begin} (\code{POSIXt}), \code{end} (\code{POSIXt}) and \code{event}}

\item{labels}{Sleep stages labels. Defaults to \code{c("N3","N2","N1","REM","AWA")}.}

\item{startTime}{Hypnogram start time. Used when a hypnodensity dataframe is passed as events. Defaults to 946681200.}

\item{epoch_duration}{Epoch duration in seconds. Used when a hypnodensity dataframe is passed as events. Defaults to 30.}

\item{plot}{Plot the hypnogram or in not using \code{ggplot2}.}
}
\value{
Hypnogram dataframe or plot.
}
\description{
Remove non-sleep stages events and reorder dataframe rows using the \code{begin} column.
}
\examples{
tryCatch({
  fpath <- paste0(tempdir(),"/15012016HD.csv")

  download.file("https://rsleep.org/data/15012016HD.csv",fpath, method="curl")

  events <- read_events_noxturnal(fpath)

  unlink(fpath)

  hypnogram(events)
 }, error = function(e) {
  print("Error executing this example, check your internet connection.")
  })
}
