% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCBI_snp_query2.R
\name{NCBI_snp_query2}
\alias{NCBI_snp_query2}
\alias{ncbi_snp_query2}
\title{Query NCBI's dbSNP for information on a set of SNPs}
\usage{
NCBI_snp_query2(SNPs, ...)

ncbi_snp_query2(SNPs, ...)
}
\arguments{
\item{SNPs}{A vector of SNPs (rs numbers).}

\item{...}{Further named parameters passed on to 
\code{\link[httr]{config}} to debug curl.}
}
\description{
Query NCBI's dbSNP for information on a set of SNPs
}
\note{
\code{ncbi_snp_query2} is a synonym of \code{NCBI_snp_query2} - we'll 
make \code{NCBI_snp_query2} defunct in the next version
}
\examples{
\dontrun{
SNPs <- c("rs332", "rs420358", "rs1837253", "rs1209415715", "rs111068718")
ncbi_snp_query2(SNPs)
# ncbi_snp_query2("123456") ## invalid: must prefix with 'rs'
ncbi_snp_query2("rs420358")
ncbi_snp_query2("rs332") # warning, merged into new one
ncbi_snp_query2("rs121909001") 
ncbi_snp_query2("rs1837253")
ncbi_snp_query2("rs1209415715") # no data available
ncbi_snp_query2("rs111068718") # chromosomal information may be unmapped
}
}
\seealso{
\code{\link{ncbi_snp_query}}
}

