% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-ao.R
\name{download_ao}
\alias{download_ao}
\title{Download Arctic Oscillation data}
\usage{
download_ao(use_cache = FALSE, file = NULL)
}
\arguments{
\item{use_cache}{logical option to save and load from cache. If `TRUE`, results will be cached in memory
if `file` is `NULL` or on disk if `file` is not `NULL`.}

\item{file}{optional character with the full path of a file to save the data. If `cache` is `FALSE` but
`file` is not `NULL`, the results will be downloaded from the internet and saved on disk.}
}
\value{
\itemize{
\item Date: Date object that uses the first of the month as a placeholder. Date formatted as date on the first of the month because R only supports one partial of date time
\item Month: Month of record
\item Year: Year of record
\item AO: Arctic Oscillation
}
}
\description{
Projection of the daily 1000 hPa anomaly height field north of 20°N on the first EOF obtained
from the monthly 1000 hPa height anomaly.
}
\examples{
\dontrun{
ao <- download_ao()
}

}
\references{
\url{https://www.ncdc.noaa.gov/teleconnections/ao/}
}
