% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.stapreg}
\alias{plot.stapreg}
\title{Plot method for stapreg objects}
\usage{
\method{plot}{stapreg}(x, plotfun = "intervals", pars = NULL,
  regex_pars = NULL, ...)
}
\arguments{
\item{x}{A fitted model object returned by one of the 
\pkg{rstap} modeling functions. See \code{\link{stapreg-objects}}.}

\item{plotfun}{A character string naming the \pkg{bayesplot} 
\link[bayesplot]{MCMC} function to use. The default is to call
\code{\link[bayesplot]{mcmc_intervals}}. \code{plotfun} can be specified
either as the full name of a \pkg{bayesplot} plotting function (e.g.
\code{"mcmc_hist"}) or can be abbreviated to the part of the name following
the \code{"mcmc_"} prefix (e.g. \code{"hist"}). To get the names of all
available MCMC functions see \code{\link[bayesplot]{available_mcmc}}.}

\item{pars}{An optional character vector of parameter names.}

\item{regex_pars}{An optional character vector of \link[=grep]{regular 
expressions} to use for parameter selection. \code{regex_pars} can be used
in place of \code{pars} or in addition to \code{pars}. Currently, all
functions that accept a \code{regex_pars} argument ignore it for models fit
using optimization.}

\item{...}{Additional arguments to pass to \code{plotfun} for customizing the
plot. These are described on the help pages for the individual plotting 
functions. For example, the arguments accepted for the default
\code{plotfun="intervals"} can be found at
\code{\link[bayesplot]{mcmc_intervals}}.}
}
\value{
Either a ggplot object that can be further customized using the
  \pkg{ggplot2} package, or an object created from multiple ggplot objects
  (e.g. a gtable object created by \code{\link[gridExtra]{arrangeGrob}}).
}
\description{
The \code{plot} method for \link{stapreg-objects} provides a convenient 
interface to the \link[bayesplot]{MCMC} module in the \pkg{\link{bayesplot}} 
package for plotting MCMC draws and diagnostics. It is also straightforward 
to use the functions from the \pkg{bayesplot} package directly rather than 
via the \code{plot} method. Examples of both methods of plotting are given
below.
}
\examples{
\dontrun{
# Not run for CRAN check speed
fit_glm <- stap_glm(formula = y ~ sex + sap(Fast_Food),
                   subject_data = homog_subject_data,
                     distance_data = homog_distance_data,
                     family = gaussian(link = 'identity'),
                     subject_ID = 'subj_id',
                     prior = normal(location = 0, scale = 5, autoscale = F),
                     prior_intercept = normal(location = 25, scale = 5, autoscale = F),
                     prior_stap = normal(location = 0, scale = 3, autoscale = F),
                     prior_theta = log_normal(location = 1, scale = 1),
                     prior_aux = cauchy(location = 0,scale = 5),
                     max_distance = max(homog_distance_data$Distance),
                     chains = CHAINS, iter = ITER,
                     refresh = -1,verbose = F)

plot(fit_glm, plotfun = 'mcmc_hist', pars = "Fast_Food")
}

}
\references{
Gabry, J., Simpson, D., Vehtari, A., Betancourt, M., and Gelman,
  A. (2018). Visualization in Bayesian workflow. \emph{Journal of the Royal
  Statistical Society Series A}, accepted for publication. arXiv preprint:
  \url{http://arxiv.org/abs/1709.01449}.
}
\seealso{
\itemize{ 
  \item The vignettes in the \pkg{bayesplot} package for many examples.
  \item \code{\link[bayesplot]{MCMC-overview}} (\pkg{bayesplot}) for links to
  the documentation for all the available plotting functions.
  \item \code{\link[bayesplot]{color_scheme_set}} (\pkg{bayesplot}) to change
  the color scheme used for plotting.
  \item \code{\link{pp_check}} for graphical posterior predictive checks.
}
}
