% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_y}
\alias{get_y}
\alias{get_z}
\alias{get_x}
\alias{get_w}
\alias{get_z.default}
\alias{get_x.default}
\title{Extract X, Y or Z from a stapreg object}
\usage{
get_y(object, ...)

get_z(object, ...)

get_x(object, ...)

get_w(object, ...)

get_z(object, ...)

\method{get_z}{default}(object, ...)

\method{get_x}{default}(object, ...)
}
\arguments{
\item{object}{A fitted model object returned by one of the 
\pkg{rstap} modeling functions. See \code{\link{stapreg-objects}}.}

\item{...}{Other arguments passed to methods. For a \code{stanmvreg} object
this can be an integer \code{m} specifying the submodel.}
}
\value{
For \code{get_x} and \code{get_z}, a matrix. For \code{get_y}, either
  a vector or a matrix, depending on how the response variable was specified.
}
\description{
The \pkg{rstap} model-fitting functions return an object of class 
\code{'stapreg'}, which is a list containing at a minimum the components listed 
below. Each \code{stapreg} object will also have additional classes (e.g. 'glm')
and several additional components depending on the model and estimation 
algorithm. \cr
\cr
}
\section{Elements for \code{stapreg} objects}{
   
\describe{
  \item{\code{coefficients}}{
  Point estimates, as described in \code{\link{print.stapreg}}.
  }
  \item{\code{ses}}{
  Standard errors based on \code{\link[stats]{mad}}, as described in
  \code{\link{print.stapreg}}.
  }
  \item{\code{residuals}}{
  Residuals of type \code{'response'}.
  }
  \item{\code{fitted.values}}{
  Fitted mean values. For GLMs the linear predictors are transformed by the
  inverse link function.
  }
  \item{\code{linear.predictors}}{
  Linear fit on the link scale. For linear models this is the same as
  \code{fitted.values}.
  }
  \item{\code{covmat}}{
  Variance-covariance matrix for the coefficients based on draws from the
  posterior distribution, the variational approximation, or the asymptotic 
  sampling distribution, depending on the estimation algorithm.
  }
  \item{\code{model,x,y,z}}{
  If requested, the the model frame, model matrix and response variable used, 
  respectively. Note that z corresponds to the fixed covariates, z to the spatial aggregated covariates, and y the response.
  }
  \item{\code{family}}{
  The \code{\link[stats]{family}} object used.
  }
  \item{\code{call}}{
  The matched call.
  }
  \item{\code{formula}}{
  The model \code{\link[stats]{formula}}.
  }
  \item{\code{data,offset,weights}}{
  The \code{data}, \code{offset}, and \code{weights} arguments.
  }
  \item{\code{prior.info}}{
  A list with information about the prior distributions used.
  }
  \item{\code{stapfit,stan_summary}}{
  The object of \code{\link[rstan]{stanfit-class}} returned by RStan and a
  matrix of various summary statistics from the stapfit object.
  }
  \item{\code{rstan_version}}{
  The version of the \pkg{rstan} package that was used to fit the model.
  }
}
}

\keyword{internal}
