/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.converters;

public class CaseObjectConverterUtils {
    private static final String CONST_ID_PREFIX = "ID:-";
    private static final String CONST_ID_SUFFIX = "-:ID";

    private CaseObjectConverterUtils() {
    }

    public static String createIdValueFromCaseId(String caseID) {
        return CONST_ID_PREFIX + caseID + CONST_ID_SUFFIX;
    }

    static String extractD3CaseIDFromInstanceID(String instanceID) {
        int prefixEndPos = instanceID.indexOf(CONST_ID_PREFIX) + CONST_ID_PREFIX.length();
        int suffixStartPos = instanceID.indexOf(CONST_ID_SUFFIX, prefixEndPos);
        if (prefixEndPos == -1 || suffixStartPos == -1) {
            return instanceID;
        }
        if (prefixEndPos < instanceID.length() && suffixStartPos < instanceID.length()) {
            return instanceID.substring(prefixEndPos, suffixStartPos);
        }
        throw new RuntimeException("Invalid ID!");
    }

    static String extractD3TitleFromInstanceID(String instanceID) {
        int idSuffixEndPos = instanceID.indexOf(CONST_ID_SUFFIX) + CONST_ID_SUFFIX.length();
        return instanceID.substring(idSuffixEndPos);
    }

    public static String extractD3IDFromIdValue(String instanceID) {
        return CaseObjectConverterUtils.extractD3CaseIDFromInstanceID(instanceID);
    }

    public static String extractD3TitleFromIdValue(String instanceID) {
        return CaseObjectConverterUtils.extractD3TitleFromInstanceID(instanceID);
    }
}

