/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.discretization;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.discretization.AbstractSupervisedDiscretizationMethod;
import org.vikamine.kernel.data.discretization.DiscretizationUtils;
import org.vikamine.kernel.subgroup.target.BooleanTarget;
import org.vikamine.kernel.subgroup.target.SGTarget;

public class ChiMergeDiscretizer
extends AbstractSupervisedDiscretizationMethod {
    private static final String NAME = "ChiMerge Discretizer";
    private static final String MAX_SEGMENT = "maxseg";
    private static final String MIN_SEGMENT = "minseg";
    private static final String PERCENTAGE = "percentage";
    private static final double P90THRESHOLD = 2.71;
    private static final double P95THRESHOLD = 3.84;
    private static final double P99THRESHOLD = 6.63;
    private static final int DEF_MINSEG = 5;
    private static final int DEF_MAXSEG = 15;
    private static final Comparator<Adjacents> AdjacentsComp = new Comparator<Adjacents>(){

        @Override
        public int compare(Adjacents o1, Adjacents o2) {
            return o1.chiSquared < o2.chiSquared ? -1 : (o1.chiSquared == o2.chiSquared ? 0 : 1);
        }
    };
    private int percentageLevel = 95;
    private int maxSegments = 15;
    private int minSegments = 5;

    public ChiMergeDiscretizer(SGTarget target) {
        this();
        this.target = target;
    }

    public ChiMergeDiscretizer(DataView population, NumericAttribute na, int segmentsCount, SGTarget target) {
        this();
        this.target = target;
        this.setPopulation(population);
        this.setAttribute(na);
        this.setSegmentsCount(segmentsCount);
    }

    public ChiMergeDiscretizer() {
    }

    public ChiMergeDiscretizer(String[] args) {
        this();
        int i = 1;
        while (i < args.length) {
            String[] arg = args[i].split("=");
            if (arg[0].contains(MAX_SEGMENT)) {
                this.maxSegments = Integer.parseInt(arg[1].trim());
            } else if (arg[0].contains(PERCENTAGE)) {
                this.percentageLevel = Integer.parseInt(arg[1].trim());
            } else if (arg[0].contains(MIN_SEGMENT)) {
                this.minSegments = Integer.parseInt(arg[1].trim());
            }
            ++i;
        }
    }

    @Override
    public void setSegmentsCount(int segmentsCount) {
        super.setSegmentsCount(segmentsCount);
        this.maxSegments = segmentsCount;
        this.minSegments = segmentsCount;
    }

    public void setPercentageLevel(int percentage) {
        this.percentageLevel = percentage;
    }

    private double determineThreshold() {
        if (this.percentageLevel >= 99) {
            return 6.63;
        }
        if (this.percentageLevel >= 95) {
            return 3.84;
        }
        return 2.71;
    }

    private static void mergeAdjacents(PriorityQueue<Adjacents> queue, int maxSegments, int minSegments, double threshold) {
        int merges = 0;
        boolean merging = true;
        int toMerge = queue.size() - maxSegments;
        int toStop = queue.size() - minSegments;
        while (merging) {
            Adjacents adjacents = queue.poll();
            if (adjacents.finalized) continue;
            if ((adjacents.chiSquared <= threshold || merges <= toMerge) && merges <= toStop) {
                ChiMergeDiscretizer.updateAdjacents(adjacents.merge(), queue);
                ++merges;
                continue;
            }
            merging = false;
        }
    }

    private static void updateAdjacents(Interval interval, PriorityQueue queue) {
        if (interval.lowerAdjacents != null) {
            WeakReference<Adjacents> newLowerAdj = new WeakReference<Adjacents>(new Adjacents((Adjacents)interval.lowerAdjacents.get()));
            interval.lowerAdjacents = newLowerAdj;
            ((Interval)((Adjacents)newLowerAdj.get()).lowerInterval.get()).upperAdjacents = (Adjacents)newLowerAdj.get();
            queue.add(newLowerAdj.get());
        }
        if (interval.upperAdjacents != null) {
            Adjacents newUpperAdj = new Adjacents(interval.upperAdjacents);
            interval.upperAdjacents = newUpperAdj;
            newUpperAdj.upperInterval.lowerAdjacents = new WeakReference<Adjacents>(newUpperAdj);
            queue.add(newUpperAdj);
        }
    }

    private static List<Double> Data2CutPoints(Adjacents firstAdjacents, ArrayList<Double> cutPoints) {
        Adjacents adjacents = firstAdjacents;
        while (adjacents != null) {
            if (!adjacents.finalized) {
                cutPoints.add(adjacents.toDouble());
            }
            adjacents = adjacents.upperInterval.upperAdjacents;
        }
        return cutPoints;
    }

    @Override
    public List<Double> getCutpoints() {
        if (!this.check()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Double> list = new ArrayList<Double>();
        this.sortedSample = DiscretizationUtils.getSortedDataRecords(this.population, this.attribute, false, false);
        AdjacentsInitializer initializer = new AdjacentsInitializer((BooleanTarget)this.target);
        initializer.initialize();
        ChiMergeDiscretizer.mergeAdjacents(initializer.queue, this.maxSegments, this.minSegments, this.determineThreshold());
        List<Double> cutPoints = ChiMergeDiscretizer.Data2CutPoints(initializer.firstInterval.upperAdjacents, list);
        return cutPoints;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static final class Adjacents {
        private WeakReference<Interval> lowerInterval;
        private final Interval upperInterval;
        private double chiSquared;
        private boolean finalized;

        private Adjacents(Interval lowerInterval, Interval upperInterval) {
            this.lowerInterval = new WeakReference<Interval>(lowerInterval);
            this.upperInterval = upperInterval;
        }

        private Adjacents(Adjacents adjacents) {
            this.lowerInterval = adjacents.lowerInterval;
            this.upperInterval = adjacents.upperInterval;
            adjacents.finalized = true;
            this.computeChiSquared();
        }

        private void computeChiSquared() {
            int instancesPositive = ((Interval)this.lowerInterval.get()).positives + this.upperInterval.positives;
            int instancesNegative = ((Interval)this.lowerInterval.get()).negatives + this.upperInterval.negatives;
            int totalAdjacent = instancesNegative + instancesPositive;
            this.chiSquared = ((Interval)this.lowerInterval.get()).chiAddand(instancesPositive, instancesNegative, totalAdjacent) + this.upperInterval.chiAddand(instancesPositive, instancesNegative, totalAdjacent);
        }

        private Interval merge() {
            Interval lowerInterval;
            Interval interval = lowerInterval = (Interval)this.lowerInterval.get();
            interval.instances = interval.instances + this.upperInterval.instances;
            Interval interval2 = lowerInterval;
            interval2.positives = interval2.positives + this.upperInterval.positives;
            Interval interval3 = lowerInterval;
            interval3.negatives = interval3.negatives + this.upperInterval.negatives;
            lowerInterval.maxValue = this.upperInterval.maxValue;
            lowerInterval.upperAdjacents = this.upperInterval.upperAdjacents;
            if (lowerInterval.upperAdjacents == null) {
                return lowerInterval;
            }
            ((Interval)lowerInterval).upperAdjacents.lowerInterval = new WeakReference<Interval>(lowerInterval);
            return lowerInterval;
        }

        private double toDouble() {
            return (((Interval)this.lowerInterval.get()).maxValue + this.upperInterval.minValue) / 2.0;
        }
    }

    private final class AdjacentsInitializer
    extends AbstractSupervisedDiscretizationMethod.Initializer {
        private final Interval firstInterval;
        private Interval currentInterval;
        private PriorityQueue<Adjacents> queue;

        private AdjacentsInitializer(BooleanTarget target) {
            super(target);
            this.currentInterval = this.firstInterval = new Interval(((DataRecord)ChiMergeDiscretizer.this.sortedSample.get(0)).getValue(ChiMergeDiscretizer.this.attribute));
        }

        @Override
        void finish() {
            this.currentInterval.maxValue = this.getValue();
            this.currentInterval.negatives = this.sumNegatives;
            this.currentInterval.positives = this.sumPositives;
            this.currentInterval.updateInstances();
            this.queue = new PriorityQueue(this.getCount(), AdjacentsComp);
            Adjacents adjacents = this.firstInterval.upperAdjacents;
            while (adjacents != null) {
                adjacents.computeChiSquared();
                this.queue.add(adjacents);
                adjacents = adjacents.upperInterval.upperAdjacents;
            }
        }

        @Override
        void createNewBlock() {
            Interval newInterval = new Interval(this.getValue());
            this.currentInterval.positives = this.sumPositives;
            this.currentInterval.negatives = this.sumNegatives;
            this.currentInterval.updateInstances();
            this.currentInterval.upperAdjacents = new Adjacents(this.currentInterval, newInterval);
            this.currentInterval.maxValue = this.getPrevValue();
            newInterval.lowerAdjacents = new WeakReference<Adjacents>(this.currentInterval.upperAdjacents);
            this.currentInterval = newInterval;
            this.resetSum();
        }
    }

    private static final class Interval {
        private final double minValue;
        private double maxValue;
        private int positives;
        private int negatives;
        private int instances;
        private WeakReference<Adjacents> lowerAdjacents;
        private Adjacents upperAdjacents;

        private Interval(double minValue) {
            this.minValue = minValue;
        }

        private void updateInstances() {
            this.instances = this.positives + this.negatives;
        }

        private double chiAddand(int instancesPositive, int instancesNegative, int totalAdjacent) {
            double expectedPositives = (double)(this.instances * instancesPositive) / (double)totalAdjacent;
            double difPositives = (double)this.positives - expectedPositives;
            double expectedNegatives = (double)(this.instances * instancesNegative) / (double)totalAdjacent;
            double difNegatives = (double)this.negatives - expectedNegatives;
            return difPositives * difPositives / Math.max(0.5, expectedPositives) + difNegatives * difNegatives / Math.max(0.5, expectedNegatives);
        }
    }
}

