/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.examples;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.creators.DataFactory;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGFilters;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.quality.functions.StandardQF;
import org.vikamine.kernel.subgroup.search.MiningTask;
import org.vikamine.kernel.subgroup.search.NumericBSD;
import org.vikamine.kernel.subgroup.selectors.SGSelectorGenerator;
import org.vikamine.kernel.subgroup.selectors.SGSelectorGeneratorFactory;
import org.vikamine.kernel.subgroup.selectors.SelectorGeneratorUtils;
import org.vikamine.kernel.subgroup.target.NumericTarget;

public class SimpleTaskRunnerExample {
    private SimpleTaskRunnerExample() {
    }

    public static void main(String[] args) throws IOException {
        Ontology onto = DataFactory.createOntology(new File("../org.vikamine.eval/resources/datasets/adults.arff"));
        System.out.println(onto.getNumAttributes());
        System.out.println(onto.getDataset().getNumInstances());
        MiningTask task = new MiningTask();
        task.setOntology(onto);
        task.setTarget(new NumericTarget(onto, "age"));
        LinkedHashSet<Attribute> attributes = onto.getAttributes();
        SGSelectorGenerator generator = SGSelectorGeneratorFactory.createStandardGenerator(10, false);
        task.setSearchSpace(SelectorGeneratorUtils.generateSelectors(generator, attributes, onto.getDataView()));
        SG initialSG = new SG(onto.getDataView(), task.getTarget());
        initialSG.createStatistics(null);
        task.setInitialSG(initialSG);
        task.getMethod().createMethodStats();
        task.setQualityFunction(new StandardQF(0.1));
        task.setMethodType(NumericBSD.class);
        task.setMaxSGDSize(5);
        task.setMaxSGCount(10);
        SGSet result = task.performSubgroupDiscovery();
        result = new SGFilters.MinImprovementFilterGlobal(0.0).filterSGs(result);
        for (SG sg : result.toSortedList(false)) {
            System.out.println(sg.getSGDescription() + " - " + sg.getStatistics().getSubgroupSize() + "(" + sg.getStatistics().getDeviation() + ")");
        }
    }
}

