/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.analysis.introspect;

import java.util.Iterator;
import java.util.List;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.subgroup.analysis.introspect.CBRResult;
import org.vikamine.kernel.subgroup.analysis.introspect.CBRResultSet;
import org.vikamine.kernel.subgroup.analysis.introspect.CompareMode;

public class CBRComparator {
    private double unknownValueFactor = 0.1;
    private CompareMode compareMode;
    private boolean useKnowledge = true;
    private Ontology ontology;
    private List attributesForCBR;

    public CBRComparator(Ontology ontology) {
        this.ontology = ontology;
    }

    public CBRResultSet compareQueryCaseWithAllCases(DataRecord queryCase) {
        CBRResultSet resultSet = new CBRResultSet(queryCase);
        Iterator<DataRecord> iter = this.ontology.getDataView().instanceIterator();
        while (iter.hasNext()) {
            DataRecord retrieveCase = iter.next();
            if (queryCase.equals(retrieveCase)) continue;
            resultSet.addResult(new CBRResult(queryCase, retrieveCase, this.calculateSimilarityBetweenQueryCaseAndRetrievedCase(queryCase, retrieveCase)));
        }
        return resultSet;
    }

    public CBRResultSet compareQueryCaseWithRetrievedCases(DataRecord queryCase, List<DataRecord> retrievedCases) {
        CBRResultSet resultSet = new CBRResultSet(queryCase);
        for (DataRecord retrievedCase : retrievedCases) {
            if (queryCase.equals(retrievedCase)) continue;
            resultSet.addResult(new CBRResult(queryCase, retrievedCase, this.calculateSimilarityBetweenQueryCaseAndRetrievedCase(queryCase, retrievedCase)));
        }
        return resultSet;
    }

    public double calculateSimilarityBetweenQueryCaseAndRetrievedCase(DataRecord queryCase, DataRecord retrievedCase) {
        double value = 0.0;
        double weightCount = 0.0;
        Iterator attributeIter = this.attributesForCBR.iterator();
        while (attributeIter.hasNext()) {
            Attribute currentAttribute;
            Attribute evaluatableAtt = currentAttribute = (Attribute)attributeIter.next();
            double queryCaseValue = queryCase.getValue(evaluatableAtt);
            double retrievedCaseValue = retrievedCase.getValue(evaluatableAtt);
            if (!this.isKnownValue(currentAttribute, queryCaseValue) && !this.isKnownValue(currentAttribute, retrievedCaseValue)) continue;
            if (this.isKnownValue(currentAttribute, queryCaseValue) && this.isKnownValue(currentAttribute, retrievedCaseValue)) {
                if (currentAttribute.isNumeric()) {
                    value += this.questionComparatorNumDivision(queryCaseValue, retrievedCaseValue);
                    weightCount += 1.0;
                    continue;
                }
                if (!currentAttribute.isNominal() && !currentAttribute.isString()) continue;
                value += this.questionComparatorOCIndividualYN(queryCaseValue, retrievedCaseValue);
                weightCount += 1.0;
                continue;
            }
            if ((!this.compareMode.equals(CompareMode.BOTH_FILL_UNKNOWN) && !this.compareMode.equals(CompareMode.QUERY_CASE_FILL_UNKNOWN) || this.isKnownValue(currentAttribute, queryCaseValue)) && (!this.compareMode.equals(CompareMode.BOTH_FILL_UNKNOWN) && !this.compareMode.equals(CompareMode.RETRIEVE_CASE_FILL_UNKNOWN) || this.isKnownValue(currentAttribute, retrievedCaseValue))) continue;
            value += 0.0;
            weightCount += this.unknownValueFactor;
        }
        return value / weightCount;
    }

    private double questionComparatorNumDivision(double queryCaseValue, double retrievedCaseValue) {
        if (queryCaseValue > retrievedCaseValue) {
            return retrievedCaseValue / queryCaseValue;
        }
        return queryCaseValue / retrievedCaseValue;
    }

    private double questionComparatorOCIndividualYN(double queryCaseValue, double retrievedCaseValue) {
        if (queryCaseValue == retrievedCaseValue) {
            return 1.0;
        }
        return 0.0;
    }

    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }

    public double getUnknownValueFactor() {
        return this.unknownValueFactor;
    }

    public void setUnknownValueFactor(double unknown_similarity) {
        this.unknownValueFactor = unknown_similarity;
    }

    public boolean isUseKnowledge() {
        return this.useKnowledge;
    }

    public void setUseKnowledge(boolean useKnowledge) {
        this.useKnowledge = useKnowledge;
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public List getAttributesForCBR() {
        return this.attributesForCBR;
    }

    public void setAttributesForCBR(List attributesForCBR) {
        this.attributesForCBR = attributesForCBR;
    }

    public boolean isKnownValue(Attribute attribute, double value) {
        if (Value.isMissingValue(value)) {
            return false;
        }
        if (attribute.isDate()) {
            return true;
        }
        if (attribute.isNumeric()) {
            return value != -1.0;
        }
        NominalAttribute att = (NominalAttribute)attribute;
        return !Value.isUnknownValue(att.getNominalValue((int)value));
    }
}

