% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ie_politicians}
\alias{ie_politicians}
\title{Politician aggregrates: Search for contributions to politicians.}
\usage{
ie_politicians(method = NULL, entity_id = NULL, cycle = NULL,
  limit = NULL, page = NULL, per_page = NULL, return = "table",
  key = getOption("SunlightLabsKey",
  stop("need an API key for Sunlight Labs")), ...)
}
\arguments{
\item{method}{(character) The query string. One of top_pol, top_con, unk_ind, top_ind, top_sec,
local_breakdown, type_breakdown, fec_summary, fec_indexp}

\item{entity_id}{(character) The transparencydata ID to look up.}

\item{cycle}{(character) Filter results to a particular type of entity. One of politician,
organization, individual or industry.}

\item{limit}{(integer) Limit number of records returned.}

\item{page}{The page of results to return; defaults to 1.}

\item{per_page}{The number of results to return per page, defaults to 1,000.
The maximum number of records per page is 100,000.}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{...}{Optional additional curl options (debugging tools mostly)}

\item{return}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}
}
\value{
A list. Depends on parameters used. Ranges from a single ID returned to basic
   information about the the contributions to and from each entity.
}
\description{
Politician aggregrates: Search for contributions to politicians.
}
\examples{
\dontrun{
# Top politicians
ie_politicians(method='top_pol', limit=1)
ie_politicians(method='top_pol', limit=3)

# Top contributors
ie_politicians(method='top_con', entity_id='4148b26f6f1c437cb50ea9ca4699417a')
ie_politicians(method='top_con', entity_id='4148b26f6f1c437cb50ea9ca4699417a',
   cycle=2012)

# Top industries
ie_politicians(method='top_ind', entity_id='4148b26f6f1c437cb50ea9ca4699417a')
ie_politicians(method='top_ind', entity_id='4148b26f6f1c437cb50ea9ca4699417a',
   cycle=2012, limit=1)

# Unkown industries
ie_politicians(method='unk_ind', entity_id='4148b26f6f1c437cb50ea9ca4699417a')

# Top sectors
ie_politicians(method='top_sec', entity_id='4148b26f6f1c437cb50ea9ca4699417a')

# Local breakdown
ie_politicians(method='local_breakdown', entity_id='97737bb56b6a4211bcc57a837368b1a4',
   cycle=2002)

# Type breakdown
ie_politicians(method='type_breakdown', entity_id='4148b26f6f1c437cb50ea9ca4699417a')
}
}

