% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsurfer.R
\name{adni.mergewithfreesurferoutput}
\alias{adni.mergewithfreesurferoutput}
\title{ADNI Merge With 'Freesurfer' Output}
\usage{
adni.mergewithfreesurferoutput(df)
}
\arguments{
\item{df}{The data frame of data imported using fsimport()}
}
\value{
The input data frame merged with Age, Gender, Diagnosis and MMSE
}
\description{
Merges the (baseline) Diagnosis, Age, Gender and MMSE for ADNI subjects with the post-processed 'Freesurfer' data, note that the rownames of the input data frame must be the Subject IDs i.e. 141_S_4232 of the ADNI database
}
\examples{
\dontrun{
setfshome("/Applications/freesurfer")
df <- fsimport.serialise("~/CADDementiaSubjects/", "~/CADSubjects.rds", verbose = T)
adni.setfiles("DXSUM_PDXCONV_ADNIALL.csv", "ADNIMERGE.csv")
df <- adni.mergewithfreesurferoutput(df)
}
}
\author{
Alexander Luke Spedding, \email{alexspedding271@gmail.com}
}
