% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{project}
\alias{project}
\title{Create or open a project or projects.}
\usage{
project(
  ssimObject = NULL,
  project = NULL,
  sourceProject = NULL,
  summary = NULL,
  forceElements = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{ssimObject}{SsimLibrary/Scenario or character. A ssimObject containing a filepath to a library, or a filepath.}

\item{project}{Character, integer, or vector of these. Names or ids of one or more projects. Note that integer ids are slightly faster.}

\item{sourceProject}{Character, integer, or Project object. If not NULL, new projects will be copies of the sourceProject.}

\item{summary}{Logical. If TRUE then return the project(s) in a dataframe with the projectId, name, description, owner, dateModified, readOnly. Default is TRUE if project=NULL and ssimObject is not Scenario/Project, FALSE otherwise.}

\item{forceElements}{Logical. If TRUE then returns a single project as a named list; otherwise returns a single project as a Project object. Applies only when summary=FALSE.}

\item{overwrite}{Logical. If TRUE an existing Project will be overwritten.}
}
\value{
Returns a \code{Project} object representing a SyncroSim project. If summary is `TRUE`,
returns a dataframe of project names and descriptions.
}
\description{
Creates or retrieves a project or multiple projects from a library.
}
\details{
For each element of project:
\itemize{
  \item {If element identifies an existing project: }{Returns the existing Project}.
  \item {If element identifies more than one project: }{Error}.
  \item {If element does not identify an existing project: }{Creates a new Project named element. Note that SyncroSim automatically assigns an id to a new project.}
}
}
\examples{
\donttest{
# Create a Library and create a new Project
temp_dir <- tempdir()
myses <- session()
myLibrary <- ssimLibrary(name = file.path(temp_dir,"testlib"), session = myses)

myProject <- project(ssimObject = myLibrary, project = "My new project name")

# Get a named list of existing Projects.
# Each element in the list is named by a character version of the Project ID.
myProjects <- project(myLibrary, summary = FALSE)
names(myProjects) # vector of the project ids

# Get an existing Project.
myProject <- myProjects[[1]]
myProject <- project(myLibrary, project = "My new project name")

# Get/set the project properties
name(myProject)
name(myProject) <- "New project name"
}

}
