% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chartInclude.R
\name{chartInclude}
\alias{chartInclude}
\alias{chartInclude,Chart-method}
\title{Add or remove values by column in a \code{\link{Chart}}}
\usage{
chartInclude(
  chart,
  variable,
  filter,
  axis = "Y",
  addValue = NULL,
  removeValue = NULL
)

\S4method{chartInclude}{Chart}(
  chart,
  variable,
  filter,
  axis = "Y",
  addValue = NULL,
  removeValue = NULL
)
}
\arguments{
\item{chart}{\code{\link{Chart}} object}

\item{variable}{character. A variable belonging to the X or Y axis.}

\item{filter}{character or character vector. A filter column belonging to
the X or Y variable.}

\item{axis}{character. Either "X" or "Y" corresponding to the X or Y axis of
the chart. Default is "Y".}

\item{addValue}{character or character vector. Adds value(s) from the
specified filter column and X or Y variable to be included in the chart.}

\item{removeValue}{character or character vector. Removes value(s) from the
specified filter column and X or Y variable from being included in the chart.}
}
\value{
A \code{Chart} object representing a SyncroSim chart
}
\description{
Add or remove values by a specified column in the X or Y axis of a
\code{\link{Chart}}.
}
\examples{
\dontrun{
# Create a chart object
myChart <- chart(myProject, chart = "New Chart")

# Set the chart type and data
myChart <- chartData(myChart, y = c("variable1", "variable2"),
timesteps = c(0,10), iterationType = "single", iteration = 1)

# Include specific values in the chart
myChart <- chartInclude(myChart, variable = "variable1",
filter="col1", addValue=c("val1", "val2", "val3"))

# Remove specific values from the chart
myChart <- chartInclude(myChart, variable = "variable1",
filter="col1", removeValue="val3")
}

}
