% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applied_reshape.r
\name{spacy_split_conjunctions}
\alias{spacy_split_conjunctions}
\title{Split conjunctions in spacy tokens}
\usage{
spacy_split_conjunctions(tokens)
}
\arguments{
\item{tokens}{a tokenIndex based on texts parsed with \code{\link[spacyr]{spacy_parse}} (with dependency=TRUE)}
}
\value{
the tokenIndex with conjunctions split into separate isolated branches.
}
\description{
The specific problem of splitting conjunctions is rather complicated because it requires recursion (for conjunctions in conjunctions) and needs to somehow deal with argument drop. 
In the sentence: "Bob ate bread and cheese", we cannot simply split the sentence into "Bob ate bread" and "cheese". We need to copy the implicit arguments to get "Bob ate bread" and "Bob ate cheese".
}
\details{
Note that this function is mainly provided for demonstration purposes.
The goal of the rsyntax package is to provide the tools to query and reshape dependency trees, and (at least for now) we want to keep applications such as this function separated.
This specific implementation is also not perfect, and for complex sentences other forms of text simplification would ideally be performed first (e.g., isolating relative clauses).
}
\examples{
tokens = tokens_spacy[tokens_spacy$doc_id == 'text5',]

\donttest{
tokens \%>\%
   spacy_split_conjunctions() \%>\%
   plot_tree()
 }
}
