% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_export.R
\name{export_as_txt}
\alias{export_as_txt}
\title{export as plain text with page break symbol}
\usage{
export_as_txt(tt, file = NULL, paginate = FALSE, ..., page_break = "\\\\s")
}
\arguments{
\item{tt}{TableTree (or related class). A TableTree object representing a populated table.}

\item{file}{character(1). File to write.}

\item{paginate}{logical(1). Should \code{tt} be paginated before writing the file.}

\item{\dots}{Passed directly to \code{\link{paginate_table}}}

\item{page_break}{character(1). Page break symbol (defualts to outputting \code{"\\s"}).}
}
\value{
\code{file} (this function is called for the side effect of writing the file.
}
\description{
export as plain text with page break symbol
}
\examples{
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  analyze(c("AGE", "BMRKR2"))

tbl <- build_table(lyt, ex_adsl)
## this just displays it
export_as_txt(tbl, file = NULL)
\dontrun{
tf <- tempfile(file.ext = ".txt")
export_as_txt(tt, file = tf)
}
}
