% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_export.R
\name{tt_to_flextable}
\alias{tt_to_flextable}
\title{Create a FlexTable object representing an rtables TableTree}
\usage{
tt_to_flextable(
  tt,
  paginate = FALSE,
  lpp = NULL,
  ...,
  colwidths = propose_column_widths(tt),
  total_width = 5
)
}
\arguments{
\item{tt}{TableTree (or related class). A TableTree object representing a populated table.}

\item{paginate}{logical(1). Should \code{tt} be paginated and exported as multiple flextables. Defaults to \code{FALSE}}

\item{lpp}{numeric. Maximum lines per page including (re)printed header and context rows}

\item{...}{Passed on to metthods or tabulation functions.}

\item{colwidths}{numeric vector. Column widths for use with vertical pagination. Currently ignored.}

\item{total_width}{numeric(1). Total width in inches for the resulting flextable(s). Defaults to 5.}
}
\value{
a flextable object
}
\description{
Create a FlexTable object representing an rtables TableTree
}
\examples{
analysisfun <- function(x, ...) {
    in_rows(row1 = 5,
            row2 = c(1, 2),
            .row_footnotes = list(row1 = "row 1 - row footnote"),
            .cell_footnotes = list(row2 = "row 2 - cell footnote"))
}

lyt <- basic_table(title = "Title says Whaaaat", subtitles = "Oh, ok.",
               main_footer = "ha HA! Footer!") \%>\%
split_cols_by("ARM") \%>\%
analyze("AGE", afun = analysisfun)

tbl <-  build_table(lyt, ex_adsl)
ft <- tt_to_flextable(tbl)
ft
}
