% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_accessors.R
\name{vars_in_layout}
\alias{vars_in_layout}
\alias{vars_in_layout,PreDataTableLayouts-method}
\alias{vars_in_layout,PreDataAxisLayout-method}
\alias{vars_in_layout,SplitVector-method}
\alias{vars_in_layout,Split-method}
\alias{vars_in_layout,CompoundSplit-method}
\alias{vars_in_layout,ManualSplit-method}
\title{List Variables required by a pre-data table layout}
\usage{
vars_in_layout(lyt)

\S4method{vars_in_layout}{PreDataTableLayouts}(lyt)

\S4method{vars_in_layout}{PreDataAxisLayout}(lyt)

\S4method{vars_in_layout}{SplitVector}(lyt)

\S4method{vars_in_layout}{Split}(lyt)

\S4method{vars_in_layout}{CompoundSplit}(lyt)

\S4method{vars_in_layout}{ManualSplit}(lyt)
}
\arguments{
\item{lyt}{The Layout (or a component thereof)}
}
\value{
A character vector containing the unique variables explicitly used in the layout (see Notes).
}
\description{
List Variables required by a pre-data table layout
}
\details{
This will walk the  layout declaration and return a vector
of the  names of the unique  variables that are used  in any of
the following ways:

\itemize{
\item{Variable being split on (directly or via cuts)}
\item{Element of a Multi-variable column split}
\item{Content variable}
\item{Value-label variable}
}
}
\note{
This function will not detect dependencies implicit in
analysis or summary functions which accept \code{x} or \code{df} and then
rely on the existence of particular variables not being split on/
analyzed.

The order these variable names appear within the return vector
is undefined and should not be relied upon.
}
\examples{
lyt <- basic_table() \%>\%
    split_cols_by("ARM") \%>\%
    split_cols_by("SEX") \%>\%
    summarize_row_groups(label_fstr = "Overall (N)") \%>\%
    split_rows_by("RACE", split_label = "Ethnicity", labels_var = "ethn_lab",
                  split_fun = drop_split_levels) \%>\%
    summarize_row_groups("RACE", label_fstr = "\%s (n)") \%>\%
    analyze("AGE", var_labels = "Age", afun = mean, format = "xx.xx")

vars_in_layout(lyt)

}
