% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_split_funs.R
\docType{data}
\name{add_overall_level}
\alias{add_overall_level}
\alias{select_all_levels}
\alias{add_combo_levels}
\title{Add overall or combination levels to split groups}
\format{
An object of class \code{AllLevelsSentinel} of length 0.
}
\usage{
add_overall_level(
  valname = "Overall",
  label = valname,
  extra_args = list(),
  first = TRUE,
  trim = FALSE
)

select_all_levels

add_combo_levels(combosdf, trim = FALSE, first = FALSE, keep_levels = NULL)
}
\arguments{
\item{valname}{(\code{string})\cr value to be assigned to the implicit all-observations split level. Defaults to
\code{"Overall"}.}

\item{label}{(\code{string})\cr a label (not to be confused with the name) for the object/structure.}

\item{extra_args}{(\code{list})\cr extra arguments to be passed to the tabulation function. Element position in the list
corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do
not match a formal argument of the tabulation function.}

\item{first}{(\code{flag})\cr whether the implicit level should appear first (\code{TRUE}) or last (\code{FALSE}). Defaults
to \code{TRUE}.}

\item{trim}{(\code{flag})\cr whether splits corresponding with 0 observations should be kept when tabulating.}

\item{combosdf}{(\code{data.frame} or \code{tbl_df})\cr a data frame with columns \code{valname}, \code{label}, \code{levelcombo}, and
\code{exargs}. \code{levelcombo} and \code{exargs} should be list columns. Passing the \code{select_all_levels} object as a value in
\code{comblevels} column indicates that an overall/all-observations level should be created.}

\item{keep_levels}{(\code{character} or \code{NULL})\cr if non-\code{NULL}, the levels to retain across both combination and
individual levels.}
}
\value{
A splitting function (\code{splfun}) that adds or changes the levels of a split.
}
\description{
\code{add_overall_level} is a split function that adds a global level to the current levels in the split. Similarly,
\code{add_combo_df} uses a user-provided \code{data.frame} to define the combine the levels to be added. If you need a
single overall column, after all splits, please check \code{\link[=add_overall_col]{add_overall_col()}}. Consider also defining
your custom split function if you need more flexibility (see \link{custom_split_funs}).
}
\note{
Analysis or summary functions for which the order matters should never be used within the tabulation framework.
}
\examples{
lyt <- basic_table() \%>\%
  split_cols_by("ARM", split_fun = add_overall_level("All Patients",
    first = FALSE
  )) \%>\%
  analyze("AGE")

tbl <- build_table(lyt, DM)
tbl

lyt2 <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("RACE",
    split_fun = add_overall_level("All Ethnicities")
  ) \%>\%
  summarize_row_groups(label_fstr = "\%s (n)") \%>\%
  analyze("AGE")
lyt2

tbl2 <- build_table(lyt2, DM)
tbl2

\dontshow{if (require(tibble)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(tibble)
combodf <- tribble(
  ~valname, ~label, ~levelcombo, ~exargs,
  "A_B", "Arms A+B", c("A: Drug X", "B: Placebo"), list(),
  "A_C", "Arms A+C", c("A: Drug X", "C: Combination"), list()
)

lyt <- basic_table(show_colcounts = TRUE) \%>\%
  split_cols_by("ARM", split_fun = add_combo_levels(combodf)) \%>\%
  analyze("AGE")

tbl <- build_table(lyt, DM)
tbl

lyt1 <- basic_table(show_colcounts = TRUE) \%>\%
  split_cols_by("ARM",
    split_fun = add_combo_levels(combodf,
      keep_levels = c(
        "A_B",
        "A_C"
      )
    )
  ) \%>\%
  analyze("AGE")

tbl1 <- build_table(lyt1, DM)
tbl1

smallerDM <- droplevels(subset(DM, SEX \%in\% c("M", "F") &
  grepl("^(A|B)", ARM)))
lyt2 <- basic_table(show_colcounts = TRUE) \%>\%
  split_cols_by("ARM", split_fun = add_combo_levels(combodf[1, ])) \%>\%
  split_cols_by("SEX",
    split_fun = add_overall_level("SEX_ALL", "All Genders")
  ) \%>\%
  analyze("AGE")

lyt3 <- basic_table(show_colcounts = TRUE) \%>\%
  split_cols_by("ARM", split_fun = add_combo_levels(combodf)) \%>\%
  split_rows_by("SEX",
    split_fun = add_overall_level("SEX_ALL", "All Genders")
  ) \%>\%
  summarize_row_groups() \%>\%
  analyze("AGE")

tbl3 <- build_table(lyt3, smallerDM)
tbl3
\dontshow{\}) # examplesIf}
}
\seealso{
\link{custom_split_funs} and \link{split_funcs}.
}
\keyword{datasets}
