\name{read.ms}
\alias{read.ms}
\title{Reading in sequences from file}
\usage{read.ms(filename, pointer.only=FALSE)
}
\description{Read Multiple Sequences from a FASTA file.}
\value{MS object containing sequences read from file}
\seealso{\code{\link{ms}} for further description of MS objects and
pointer.only option.}
\keyword{ms}
\arguments{\item{filename}{The name of the input file containing the sequences.
File should be in FASTA format.}
\item{pointer.only}{If \code{TRUE}, sequences within the MS
will be stored by reference as external pointers to objects created 
by C code, rather than directly in R memory.  This improves 
performance and may be necessary for large files, but reduces
functionality.}
}

\examples{
require("rtfbs")
exampleArchive <- system.file("extdata", "NRSF.zip", package="rtfbs")
seqFile <- "input.fas"
unzip(exampleArchive, seqFile)
# Read in FASTA file "input.fas" from the examples into an 
#   MS (multiple sequences) object
seqs <- read.ms(seqFile)
# Print the number of sequences in the MS object and whether
#   stored in C or R
print(seqs)
}
