% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elsevier_article.R
\name{elsevier_article}
\alias{elsevier_article}
\title{Elsevier journal format.}
\usage{
elsevier_article(..., keep_tex = TRUE,
  md_extensions = c("-autolink_bare_uris"))
}
\arguments{
\item{...}{Additional arguments to \code{rmarkdown::pdf_document}}

\item{keep_tex}{Keep the intermediate tex file used in the conversion to PDF}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition or R Markdown. See the \code{\link{rmarkdown_format}}
for additional details.}
}
\value{
R Markdown output format to pass to
  \code{\link[rmarkdown:render]{render}}
}
\description{
Format for creating submissions to Elsevier journals. Adapted from
\href{https://www.elsevier.com/authors/author-schemas/latex-instructions}{https://www.elsevier.com/authors/author-schemas/latex-instructions}.
}
\examples{

\dontrun{
library(rmarkdown)
draft("MyArticle.Rmd", template = "elsevier_article", package = "rticles")
}

}

