% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_polar_smooths}
\alias{plot_polar_smooths}
\title{Plot smooths from a polar \code{gam}}
\usage{
plot_polar_smooths(
  model,
  series,
  comparison = NULL,
  origin = NULL,
  facet_terms = NULL,
  conditions = NULL,
  exclude_random = TRUE,
  series_length = 100,
  split = NULL,
  sep = "\\\\.",
  time_series
)
}
\arguments{
\item{model}{A \code{gam} or \code{bam} model object.}

\item{series}{An unquoted expression indicating the model term that defines the series on which smoothing is applied. This is the term that is displayed on the x-axis when plotting.}

\item{comparison}{An unquoted expression indicating the model term for which the comparison will be plotted.}

\item{origin}{The coordinates of the origin as a vector of \code{c(x, y)} coordinates.}

\item{facet_terms}{An unquoted formula with the terms used for faceting.}

\item{conditions}{A list of quosures with \link[rlang]{quos} specifying the levels to plot from the model terms not among \code{series}, \code{comparison}, or \code{facet_terms}.}

\item{exclude_random}{Whether to exclude random smooths (the default is \code{TRUE}).}

\item{series_length}{An integer indicating how many values along the time series to use for predicting the outcome term.}

\item{split}{Columns to separate as a named list.}

\item{sep}{Separator between columns (default is \code{"\\."}, which is the default with \code{}). If character, it is interpreted as a regular expression.}

\item{time_series}{Deprecated, use \code{series} instead.}
}
\value{
An object of class \code{\link[ggplot2]{ggplot}}.
}
\description{
It plots the smooths of a polar GAM fitted with \code{polar_gam()}.
}
\examples{
\donttest{
library(tidyverse)
tongue_it01 <- filter(tongue, speaker == "it01")
pgam <- polar_gam(Y ~ s(X, by = as.factor(label)), data = tongue_it01)

plot_polar_smooths(pgam, X, label)
}
}
