% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tika_check.R
\name{tika_check}
\alias{tika_check}
\title{Check Tika against a md5 checksum}
\usage{
tika_check(md5_sum, jar = tika_jar())
}
\arguments{
\item{md5_sum}{Character vector of length one with the target md5 checksum.}

\item{jar}{Optional alternative path to a Tika \code{jar} file.}
}
\value{
logical if the \code{jar} checksum matches \code{md5_sum}.
}
\description{
This is used by \code{install_tika()} internally, 
or can be called directly on a \code{jar} file.
The latest \code{jar} files and checksums are at https://tika.apache.org/download.html.
The \code{tools::md5sum()} function is used here. 
Optionally, a user may install and use the \code{digest::digest()} function
to double check the \code{SHA-512} checksum
for the \code{tika_jar()} file.
}
