% Generated by roxygen2 (4.0.2): do not edit by hand
\name{clusterStrategy}
\alias{clusterFastStrategy}
\alias{clusterStrategy}
\title{Create an instance of [\code{\linkS4class{ClusterStrategy}}] class}
\usage{
clusterStrategy(nbTry = 1, nbInit = 3, initMethod = "random",
  initAlgo = "SEM", nbInitIteration = 20, initEpsilon = 0.01,
  nbShortRun = 5, shortRunAlgo = "EM", nbShortIteration = 100,
  shortEpsilon = 1e-04, longRunAlgo = "EM", nbLongIteration = 1000,
  longEpsilon = 1e-07)

clusterFastStrategy()
}
\arguments{
\item{nbTry}{number of estimation to attempt.}

\item{nbInit}{Integer defining the number of initialization to try. Default value: 3.}

\item{initMethod}{Character string with the initialization method, see [\code{\link{clusterInit}}]$
for possible values. Default is "random".}

\item{initAlgo}{Character string with the algorithm to use in the initialization stage,
[\code{\link{clusterAlgo}}] for possible values. Default value: "SEM".}

\item{nbInitIteration}{Integer defining the maximal number of iterations in initialization algorithm
if \code{initAlgo} = "EM", "CEM" or "SemiSEM". This is the number of iterations if \code{initAlgo} = "SEM".
Default value: 20.}

\item{initEpsilon}{Real defining the epsilon value for the algorithm.
\code{initEpsilon} is not used by the \code{SEM} algorithm. Default value: 0.01.}

\item{nbShortRun}{Integer defining the number of short run to try
(the strategy launch an initialization before each short run). Default value: 5.}

\item{shortRunAlgo}{A character string with the algorithm to use in the short run stage
Default value: "EM".}

\item{nbShortIteration}{Integer defining the maximal number of iterations in the short runs
if \code{shortRunAlgo} = "EM", "CEM" or "semiSEM", or the number of iterations if \code{shortRunAlgo} = "SEM".
Default value: 100.}

\item{shortEpsilon}{Real defining the epsilon value for the algorithm.
epsilon is not used by the \code{SEM} algorithm. Default value: 1e-04.}

\item{longRunAlgo}{A character string with the algorithm to use in the long run stage
Default value: "EM".}

\item{nbLongIteration}{Integer defining the maximal number of iterations in the short runs
if \code{shortRunAlgo} = "EM", "CEM" or "SemiSEM", or the number of iterations if \code{shortRunAlgo} = "SEM".
Default value: 1000.}

\item{longEpsilon}{Real defining the epsilon value for the algorithm.
epsilon is not used by the \code{SEM} algorithm. Default value: 1e-07.}
}
\value{
a [\code{\linkS4class{ClusterStrategy}}] object
}
\description{
A strategy is a multistage empirical process for finding a
good estimate in the clusering estimation process.

\code{clusterFastStrategy()} create an instance of [\code{\linkS4class{ClusterStrategy}}] for impatient user.
}
\details{
A strategy is a way to find a good estimate of the parameters of a mixture model
when using an EM algorithm. A ``try'' is composed of three stages
\itemize{
  \item \code{nbShortRun} short iterations of the initialization step and
   of the \code{EM}, \code{CEM}, \code{SEM} or \code{SemiSEM} algorithm.
  \item \code{nbInit} initializations using the [\code{\link{clusterInit}}]
  method.
  \item A long run of the \code{EM}, \code{CEM}, \code{SEM} or \code{SemiSEM} algorithm.
}
For exemple if \code{nbInit} is 5 and \code{nbShortRun} is also 5, there will be
5 packets of 5 models initialized. In each packet, the best model will be ameliorated using
a short run. Among the 5 models ameliorated one will be estimated until convergence
using a long run.

This process can be repeated at least \code{nbTry} times. If all the tries failed,
an empty model is returned.
}
\examples{
clusterStrategy()
   clusterStrategy(longRunAlgo= "CEM", nbLongIteration=100)
   clusterStrategy(nbTry = 1, nbInit= 1, shortRunAlgo= "SEM", nbShortIteration=100)
clusterFastStrategy()
}
\author{
Serge Iovleff
}

