% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_post.R
\name{vcov.trim}
\alias{vcov.trim}
\title{Extract variance-covariance matrix from TRIM output}
\usage{
\method{vcov}{trim}(object, which = c("imputed", "model"), ...)
}
\arguments{
\item{object}{TRIM output structure (i.e., output of a call to \code{trim})}

\item{which}{\code{[character]} Selector to distinguish between variance-covariance based on the
imputed data (default), or the modelled data.}

\item{...}{Arguments to pass to or from other methods (currently unused)}
}
\value{
a JxJ matrix, where J is the number of time points.
}
\description{
Extract variance-covariance matrix from TRIM output
}
\examples{
data(skylark)
z <- trim(count ~ site + time, data=skylark, model=2);
totals(z)
vcv1 <- vcov(z)       # Use imputed data
vcv2 <- vcov(z,"model") # Use modelled data
}
\seealso{
Other analyses: \code{\link{coef.trim}}, \code{\link{gof}},
  \code{\link{index}}, \code{\link{now_what}},
  \code{\link{overall}}, \code{\link{overdispersion}},
  \code{\link{plot.trim.index}},
  \code{\link{plot.trim.overall}}, \code{\link{results}},
  \code{\link{serial_correlation}},
  \code{\link{summary.trim}}, \code{\link{totals}},
  \code{\link{trim}}, \code{\link{wald}}
}

