% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_dup.R
\name{rtry_remove_dup}
\alias{rtry_remove_dup}
\title{Remove duplicates in data}
\usage{
rtry_remove_dup(input, showOverview = TRUE)
}
\arguments{
\item{input}{Input data frame or data table.}

\item{showOverview}{Default \code{TRUE} displays the the dimension of the data after removing the duplicates.}
}
\value{
An object of the same type as the input data after removing the duplicates.
}
\description{
This function removes the duplicates from the input data using the duplicate identifier
\code{OrigObsDataID} provided within the TRY data. Once the function is called and executed,
the number of duplicates removed will be displayed on the console as reference.
}
\note{
This function depends on the duplicate identifier \code{OrigObsDataID} listed
in the data exported from the TRY database, therefore, if the column \code{OrigObsDataID}
has been removed, this function will not work. Also, if the original value of an
indicated duplicate is a restricted value, which has not been requested from
the TRY database (if only public data were requested), the duplicate will be
removed and this may result in data loss.
}
\examples{
# Remove the duplicates within the provided sample data (data_TRY_15160)
data_rm_dup <- rtry_remove_dup(data_TRY_15160)

# Expected message:
# 45 duplicates removed.
# dim:   1737 28
}
\references{
This function makes use of the \code{\link[base]{subset}} function
within the \code{base} package.
}
