% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_makeframes.R
\name{ts_makeframes}
\alias{ts_makeframes}
\title{Create spatial ggplots of a raster time series}
\usage{
ts_makeframes(
  x_list,
  r_type = NULL,
  minq = 0.02,
  maxq = 0.98,
  samplesize = 1000,
  blacken_NA = FALSE,
  l_indices = NULL,
  alpha = NULL,
  hillshade = NULL,
  ...
)
}
\arguments{
\item{x_list}{a list of raster objects.}

\item{r_type}{(Optional) character, one of \code{"discrete"}, \code{"gradient"} or \code{"RGB"}. By default, attempts to discern the \code{r_type} from the content of \code{r_list}.}

\item{minq}{(Optional) numeric, lower quantile boundary for the stretch.  Default is \code{0.02}.}

\item{maxq}{(Optional) numeric, upper quantile boundary for the stretch. Default is \code{0.98}.}

\item{samplesize}{(Optional) numeric, number of samples per layer to determine the quantile from. See \link[raster]{sampleRegular} for details on the sampling. Default is \code{1000}.}

\item{blacken_NA}{(Optional) logical. If \code{TRUE}: set \code{NA} to \code{0}. Default is \code{FALSE}.}

\item{l_indices}{(Optional) numeric, a vector of layer indices specifying which layers are to be plotted. Should contain 3 values for an RGB image or a single value for a discrete or gradient image. By default, chooses the first three layers if \code{r_type} is \code{"RGB"} and the first layer if \code{r_type} is \code{"discrete"} or \code{"gradient"}.}

\item{alpha}{(Optional) numeric. The opacity of the plot. Default is 1.}

\item{hillshade}{(Optional) A raster layer. If one is provided, it will be used as the base layer and plotted with \link[RStoolbox]{ggR} while the raster layers from x_list will be plotted over it with a default \code{alpha} of 0.5. By default, no hillshade is used.}

\item{...}{(Optional) further arguments for the plotting.}
}
\value{
A list of ggplots
}
\description{
Create spatial ggplots of a raster time series
}
\details{
A linear percent stretch will be applied to each band to improve contrast.
#\deqn{(X - Low_{in}) * \frac{((High_{out}-Low_{out})}{(High_{in}-Low_{in}))}  + Low_{out}}
# The stretch parameters 
# \eqn{High_{out}},\eqn{Low_{out}},\eqn{High_{in}},\eqn{Low_{in}}
#  are calculated separately for each band based on the \code{minq} and \code{maxq} which are first applied to \code{samplesize} regular samples (see \link[raster]{sampleRegular}) of each individual layer.
 From these, across all layers belonging to a certain band, the minimum and maximum values are taken as the stretching parameters for the linear stretch, which is performed using  \link[RStoolbox]{rescaleImage}.  Discrete \code{r_type}s will not be stretched.
  To further enhance the plots, consider using functionalities implemented in \pkg{moveVis},
(see \url{http://movevis.org/} ). For example, a northarrow may be added to all frames using \link[moveVis]{add_northarrow}.
}
\examples{
#Setup
# Load example dataset at a greatly increased interval
x_list <- MODIS_SI_ds[seq(1,length(MODIS_SI_ds),25)]
x_dates <- do.call(c, lapply(MODIS_SI_ds,attr,"time") )[seq(1,length(MODIS_SI_ds),25)]

#Fill NAs
x_list_filled <- ts_fill_na(x_list)

#Make a sequence of output dates, double the length of input dates
out_dates <-seq.POSIXt(from = x_dates[1],
                       to = x_dates[length(x_dates)],length.out = length(x_dates)*2 )

#For each output date, interpolate a raster image from the input files
r_list_out <- ts_raster(r_list = x_list_filled,
                        r_times = x_dates,
                        out_times = out_dates,
                        fade_raster = TRUE)
#Create the frames 
# as from the desired layers
r_frames <- ts_makeframes(x_list = r_list_out,samplesize = 10,
                          l_indices = c(1,4,3))
}
\author{
Johannes Mast
}
