% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/friends.R
\name{get_friends}
\alias{get_friends}
\title{get_friends}
\usage{
get_friends(user, token = NULL, page = "-1", stringify = TRUE)
}
\arguments{
\item{user}{Screen name or user id of target user.}

\item{token}{OAuth token (1.0 or 2.0). By default
\code{token = NULL} fetches a non-exhausted token from
an environment variable.}

\item{page}{Numeric or character vector used as cursor value.
Default \code{page = -1} specifies first page of json results,
or first 5000 friends. Other pages specified via cursor values
supplied by Twitter API response object.}

\item{stringify}{Logical, indicating whether to return user
ids as strings (some ids are too long to be read as numeric).
Defaults to \code{TRUE}.}
}
\value{
friends User ids for everyone a user follows.
}
\description{
Requests information from Twitter's REST API
  regarding a user's friend network (i.e., accounts followed
  by a user). To request information on followers of accounts
}
\examples{
\dontrun{
# get ids of users followed by the president of the US
pres <- get_friends(user = "potus")
pres

# get ids of users followed by the Environmental Protection Agency
epa <- get_friends(user = "epa")
epa
}

}
\seealso{
\url{https://dev.twitter.com/overview/documentation}
}

