% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_plot.R
\name{ts_data}
\alias{ts_data}
\title{Converts tweets data into time series-like data object.}
\usage{
ts_data(data, by = "days", trim = 0L)
}
\arguments{
\item{data}{Data frame or grouped data frame.}

\item{by}{Desired interval of time expressed as numeral plus one of
"secs", "mins", "hours", "days", "weeks", "months", or
"years". If a numeric is provided, the value is assumed to be in
seconds.}

\item{trim}{Number of observations to trim off the front and end of
each time series}
}
\value{
Data frame with time, n, and grouping column if applicable.
}
\description{
Returns data containing the frequency of tweets over a specified
interval of time.
}
\examples{

\dontrun{

## handles of women senators
sens <- c("SenatorBaldwin", "SenGillibrand", "PattyMurray", "SenatorHeitkamp")

## get timelines for each
sens <- get_timeline(sens, n = 3200)

## get single time series for tweets
ts_data(sens)

## using weekly intervals
ts_data(sens, "weeks")

## group by screen name and then use weekly intervals
sens \%>\%
  dplyr::group_by(screen_name) \%>\%
  ts_plot("weeks")

}

}
