% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packs.R
\name{group-pack}
\alias{group-pack}
\title{Group rule pack}
\description{
Group rule pack is a \link[=rule-packs]{rule pack} which defines a set of rules
for groups of rows as a whole, i.e. functions which convert groups of
interest to logical values. It should return a data frame with the following
properties:
\itemize{
\item There should be present some columns which combined values \strong{uniquely}
describe group. They should be defined during creation with
\link[=rule-packs]{group_packs()}.
\item Number of rows equals to \strong{number of checked groups}.
\item Names of non-grouping columns should be treated as \strong{rule names}.
\item Values indicate whether the \strong{group as a whole} follows the rule.
}
}
\details{
This format is inspired by \code{dplyr}'s \link[dplyr:summarise]{summarise()} applied
to grouped data.

The most common way to define data pack is by creating a
\link[magrittr:pipe]{functional sequence} with grouping and ending with
\code{summarise(...)}.
}
\section{Interpretation}{

Group pack output is interpreted in the following way:
\itemize{
\item All grouping columns are \link[tidyr:unite]{united} with delimiter \code{.group_sep}
(which is an argument of \code{group_packs()}).
\item Levels of the resulting column are treated as names of some new variables
which should be exposed as a whole. Names of non-grouping columns are treated
as rule names. They are transformed in \link[=column-pack]{column pack} format and
interpreted accordingly.
}

Exposure result of group pack is different from others in a way that column
\code{var} in \link[=ruler-report]{exposure report} doesn't represent the actual column
in data.
}

\examples{
vs_am_rules <- . \%>\%
  dplyr::group_by(vs, am) \%>\%
  dplyr::summarise(
    nrow_low = n(.) > 10,
    nrow_up = n(.) < 20,
    rowmeans_low = rowMeans(.) > 19
  )

group_packs(vs_am = vs_am_rules, .group_vars = c("vs", "am"))
}
\seealso{
\link[=data-pack]{Data pack}, \link[=column-pack]{Column pack}, \link[=row-pack]{row pack}, \link[=cell-pack]{cell pack}.
}
