% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C5_rules.R, R/cubist_rules.R, R/rule_fit.R
\name{rules_update}
\alias{rules_update}
\alias{update.C5_rules}
\alias{update.cubist_rules}
\alias{update.rule_fit}
\title{Updating a model specification}
\usage{
\method{update}{C5_rules}(
  object,
  parameters = NULL,
  trees = NULL,
  min_n = NULL,
  fresh = FALSE,
  ...
)

\method{update}{cubist_rules}(
  object,
  parameters = NULL,
  committees = NULL,
  neighbors = NULL,
  max_rules = NULL,
  fresh = FALSE,
  ...
)

\method{update}{rule_fit}(
  object,
  parameters = NULL,
  mtry = NULL,
  trees = NULL,
  min_n = NULL,
  tree_depth = NULL,
  learn_rate = NULL,
  loss_reduction = NULL,
  sample_size = NULL,
  penalty = NULL,
  fresh = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{rule_fit} model specification.}

\item{parameters}{A 1-row tibble or named list with \emph{main} parameters to update.
If the individual arguments are used, these will supersede the values in
parameters. Also, using engine arguments in this object will result in an
error.}

\item{trees}{A non-negative integer (no greater than 100 for the number
of members of the ensemble.}

\item{min_n}{An integer greater than one zero and nine for the minimum number
of data points in a node that are required for the node to be split further.}

\item{fresh}{A logical for whether the arguments should be modified in-place
or replaced wholesale.}

\item{...}{Not used for \code{update()}.}

\item{committees}{A non-negative integer (no greater than 100 for the number
of members of the ensemble.}

\item{neighbors}{An integer between zero and nine for the number of training
set instances that are used to adjust the model-based prediction.}

\item{max_rules}{The largest number of rules.}

\item{mtry}{An number for the number (or proportion) of predictors that will
be randomly sampled at each split when creating the tree models.}

\item{tree_depth}{An integer for the maximum depth of the tree (i.e. number
of splits).}

\item{learn_rate}{A number for the rate at which the boosting algorithm adapts
from iteration-to-iteration.}

\item{loss_reduction}{A number for the reduction in the loss function required
to split further .}

\item{sample_size}{An number for the number (or proportion) of data that is
exposed to the fitting routine.}

\item{penalty}{L1 regularization parameter.}
}
\description{
Updating a model specification
}
\examples{

# ------------------------------------------------------------------------------

model <- C5_rules(trees = 10, min_n = 2)
model
update(model, trees = 1)
update(model, trees = 1, fresh = TRUE)

# ------------------------------------------------------------------------------

model <- cubist_rules(committees = 10, neighbors = 2)
model
update(model, committees = 1)
update(model, committees = 1, fresh = TRUE)
# ------------------------------------------------------------------------------

model <- rule_fit(trees = 10, min_n = 2)
model
update(model, trees = 1)
update(model, trees = 1, fresh = TRUE)
}
