% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MB_Server.R
\name{mk_rx_obj}
\alias{mk_rx_obj}
\title{Makes an rxode2 Object}
\usage{
mk_rx_obj(type, model)
}
\arguments{
\item{type}{Type of supplied model can be "rxode2", "NONMEM"}

\item{model}{List containing the relevant information about the model. This
will depend on the model types.
\itemize{
\item{rxode2:} The supplied model is in the rxode2 format.
\itemize{
\item{fcn_def:} Character string containing function definition.
\item{fcn_obj:} Name of the funciton object created in \code{fcn_def}.
}
\item{NONMEM:} The supplied model is in NONMEM format (either a control
\itemize{
\item{model_file:} Character string containing the NONMEM model file.
}
}}
}
\value{
Results of \code{FM_tc()} when running the model. This will include
a field \code{isgood} which is a boolean variable indicating success or
failure. See the documentation for \code{FM_tc()} for the format returned
when evaluation results in a failure and how to address those. When
successful the \code{capture} field will contain the following:
\itemize{
\item{fcn_obj:} The function name.
\item{rx_obj:} The built rxode2 object.
}
}
\description{
Creates an rxode2 object from a model (either rxode2 function
or a NONMEM file)
}
\examples{
fcn_def = ' my_func = function ()
   {
       description <- "One compartment PK model with linear clearance"
       ini({
           lka <- 0.45
           label("Absorption rate (Ka)")
           lcl <- 1
           label("Clearance (CL)")
           lvc <- 3.45
           label("Central volume of distribution (V)")
           propSd <- c(0, 0.5)
           label("Proportional residual error (fraction)")
       })
       model({
           ka <- exp(lka)
           cl <- exp(lcl)
           vc <- exp(lvc)
           cp <- linCmt()
           cp ~ prop(propSd)
       })

   }'
fcn_obj = "my_func"
model = list(fcn_def = fcn_def,
             fcn_obj = fcn_obj)


rx_res = mk_rx_obj("rxode2", model)

# function object
rx_res[["capture"]][["fcn_obj"]]

# rxode2 object
rx_res[["capture"]][["rx_obj"]]
}
