% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvci.R
\name{rvci}
\alias{rvci}
\title{Credible (Uncertainty) Intervals for Random Scalars}
\usage{
rvci(obj, interval = 0.95, one.sided = FALSE, left = TRUE)
}
\arguments{
\item{obj}{random scalar or vector}

\item{interval}{size of the middle interval or the quantile range of the
interval}

\item{one.sided}{logical, FALSE if two-sided interval is desired}

\item{left}{logical, indicating if the left one-sided interval is desired}
}
\value{
For two-sided intervals, an array of numbers of dimension
\code{c(2,length(x))}, for one-sided intervals, a vector of the same length
as \code{x}.
}
\description{
Computes credible (uncertainty) intervals for a given vector, given
quantiles or the size of the middle interval
}
\details{
If \code{interval} is of length two or more, the return value will be the
quantiles given by \code{range(interval)}.
}
\examples{

  rvci(rvnorm(1), interval=0.683) # Should be about c(-1,1).

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
