% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dml_docx.R
\name{dml_docx}
\alias{dml_docx}
\title{DrawingML graphic device for Microsoft Word}
\usage{
dml_docx(file = "Rplots.dml", width = 6, height = 6, bg = "white",
  fonts = list(), pointsize = 12, editable = TRUE, id = 1L,
  last_rel_id = 1L, raster_prefix = "raster_", standalone = TRUE)
}
\arguments{
\item{file}{DrawingML file.}

\item{height, width}{Height and width in inches.}

\item{bg}{Default background color for the plot (defaults to "white").}

\item{fonts}{Named list of font names to be aliased with
fonts installed on your system. If unspecified, the R default
families \code{sans}, \code{serif}, \code{mono} and \code{symbol}
are aliased to the family returned by \code{\link[gdtools]{match_family}()}.}

\item{pointsize}{default point size.}

\item{editable}{should vector graphics elements (points, text, etc.)
be editable.}

\item{id}{specifies a unique identifier (integer) within the document
that will contain the DrawingML instructions.}

\item{last_rel_id}{specifies the last unique identifier (integer)
within relationship file that will be used to reference embedded
raster images if any.}

\item{raster_prefix}{string value used as prefix for png
files produced when raster objects are printed on the
graphical device.}

\item{standalone}{produce a standalone drawingml file? If \code{FALSE}, omits
xml header and namespaces.}
}
\description{
Graphics devices for Microsoft Word DrawingML format.
}
\note{
Text rendering is not optimal, this device should not be considered as a
valid R graphical device.

The DrawingML implementation for 'Microsoft Word' is different from standard
DrawingML particulary with text boxes. The major point is that the exact size
and position of text boxes cannot be exactly defined regarding to text widths
and heights.

Autofit option has been set as a workaround, this moves text slightly on the produced graphic when
edited in 'Microsoft Word' but this makes sure the text can be read.

This function is deprecated and should not be used as it will be removed in version > 0.1.9.
}
\examples{
\donttest{
dml_docx( file = tempfile() )
plot(1:11,(-5:5)^2, type='b', main="Simple Example")
dev.off()
}
}
\seealso{
\code{\link{Devices}}
}
\keyword{device}
