% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvine_structure.R
\name{plot.rvine_structure}
\alias{plot.rvine_structure}
\alias{plot.rvine_matrix}
\title{Plotting R-vine structures}
\usage{
\method{plot}{rvine_structure}(x, tree = 1, edge_labels = FALSE, ...)

\method{plot}{rvine_matrix}(x, tree = 1, edge_labels = FALSE, ...)
}
\arguments{
\item{x}{an \code{rvine_structure} or \code{rvine_matrixc} object.}

\item{tree}{\code{"ALL"} or integer vector; specifies which trees are
plotted.}

\item{edge_labels}{either \code{TRUE} or \code{FALSE}; if \code{TRUE} the edge index is
added to the plot.}

\item{...}{unused.}
}
\description{
Plot one or all trees of an R-vine structure.
}
\examples{
plot(cvine_structure(1:5))
plot(rvine_structure_sim(5))
mat <- rbind(c(1, 1, 1), c(2, 2, 0), c(3, 0, 0))
plot(rvine_matrix(mat))
plot(rvine_matrix_sim(5))
}
