% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_codespace.R
\name{use_codespace}
\alias{use_codespace}
\title{Use Codespace}
\usage{
use_codespace(
  template = "devcontainer.json",
  image = "ghcr.io/neurogenomics/rworkflows:dev",
  features = list(`ghcr.io/devcontainers/features/conda:1` = list()),
  customizations = list(vscode = list(settings = list(), extensions =
    list("reditorsupport.r", "visualstudioexptteam.vscodeintellicode",
    "ionutvmi.path-autocomplete"))),
  save_dir = here::here(".devcontainer"),
  path = file.path(save_dir, template),
  force_new = FALSE,
  show = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{template}{Dev container config template to use.}

\item{image}{Base Docker image to use for the Codespace.}

\item{features}{Named list of features to add to the Codespace.
See \href{https://docs.github.com/en/codespaces/setting-up-your-project-for-codespaces/configuring-dev-containers/adding-features-to-a-devcontainer-file}{here}
 for details.}

\item{customizations}{Named list of customizations to add to the Codespace.
See \href{https://containers.dev/supporting}{here}
 for details.}

\item{save_dir}{Directory to save the file to.}

\item{path}{Path to the file.}

\item{force_new}{If the file already exists, overwrite it 
(default: \code{FALSE}).}

\item{show}{Print the contents of the file in the R console.}

\item{verbose}{Print messages.}
}
\value{
Path to dev container config file.
}
\description{
Generate a dev container config file to set up a 
\href{https://docs.github.com/en/codespaces}{GitHub Codespace}.
}
\examples{
path <- use_codespace(save_dir=tempdir())
}
