% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/yesterday.R
\name{yesterday}
\alias{yesterday}
\title{Weather data for yesterday}
\usage{
yesterday(location, use_metric = FALSE, key = get_api_key(), raw = FALSE,
  message = TRUE, summary = FALSE)
}
\arguments{
\item{location}{location set by set_location}

\item{use_metric}{Metric or imperial units}

\item{key}{weather underground API key}

\item{raw}{if TRUE return raw httr object}

\item{message}{if TRUE print out requested URL}

\item{summary}{If TRUE return daily summary otherwise hourly data}
}
\value{
tbl_df with date, temperature, dew point,
        humidity, wind speed, gust and direction,
        visibility, pressure, wind chill, heat index,
        precipitation, condition, fog, rain, snow,
        hail, thunder, tornado
}
\description{
Weather data for yesterday
}
\examples{
\dontrun{
yesterday(set_location(territory = "Hawaii", city = "Honolulu"))
yesterday(set_location(territory = "Iowa", city = "Iowa City"))
yesterday(set_location(territory = "Iraq", city = "Baghdad"))
yesterday(set_location(territory = "IR", city = "Tehran"), summary = TRUE)
}
}

