% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llik.R
\name{llikPois}
\alias{llikPois}
\title{log-likelihood for the Poisson distribution}
\usage{
llikPois(x, lambda, full = FALSE)
}
\arguments{
\item{x}{non negative integers}

\item{lambda}{non-negative means}

\item{full}{Add the data frame showing x, mean, sd as well as the
fx and derivatives}
}
\value{
data frame with \code{fx} for the pdf value of with
\code{dLambda} that has the derivatives with respect to the parameters at
the observation time-point
}
\description{
log-likelihood for the Poisson distribution
}
\details{
In an \code{rxode2()} model, you can use \code{llikPois()} but you have to
use all arguments.  You can also get the derivatives with
\code{llikPoisDlambda()}
}
\examples{
\donttest{
llikPois(0:7, lambda = 1)

llikPois(0:7, lambda = 4, full=TRUE)

# In rxode2 you can use:

et <- et(0:10)
et$lambda <- 0.5

model <- rxode2({
  fx <- llikPois(time, lambda)
  dLambda <- llikPoisDlambda(time, lambda)
})

rxSolve(model, et)
}
}
\author{
Matthew L. Fidler
}
