% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxrandom.R
\name{rxPp}
\alias{rxPp}
\title{Simulate a from a Poisson process}
\usage{
rxPp(
  n,
  lambda,
  gamma = 1,
  prob = NULL,
  t0 = 0,
  tmax = Inf,
  randomOrder = FALSE
)
}
\arguments{
\item{n}{Number of time points to simulate in the Poisson process}

\item{lambda}{Rate of Poisson process}

\item{gamma}{Asymmetry rate of Poisson process.  When gamma=1.0,
this simulates a homogenous Poisson process.  When gamma<1.0,
the Poisson process has more events early, when gamma > 1.0,
the Poisson process has more events late in the process.

When gamma is non-zero, the tmax should not be infinite but indicate
the end of the Poisson process to be simulated.  In most
pharamcometric cases, this will be the end of the study.
Internally this uses a rate of:

l(t) = lambda\emph{gamma}(t/tmax)^(gamma-1)}

\item{prob}{When specified, this is a probability function with
one argument, time, that gives the probability that a Poisson
time t is accepted as a rejection time.}

\item{t0}{the starting time of the Poisson process}

\item{tmax}{the maximum time of the Poisson process}

\item{randomOrder}{when \code{TRUE} randomize the order of the Poisson
events.  By default (\code{FALSE}) it returns the Poisson process is
in order of how the events occurred.}
}
\value{
This returns a vector of the Poisson process times; If the dropout is >=
tmax, then all the rest of the times are = tmax to indicate the
dropout is equal to or after tmax.
}
\description{
Simulate a from a Poisson process
}
\examples{

## Sample homogenous Poisson process of rate 1/10
rxPp(10, 1 / 10)

## Sample inhomogenous Poisson rate of 1/10

rxPp(10, 1 / 10, gamma = 2, tmax = 100)

## Typically the Poisson process times are in a sequential order,
## using randomOrder gives the Poisson process in random order

rxPp(10, 1 / 10, gamma = 2, tmax = 10, randomOrder = TRUE)

## This uses an arbitrary function to sample a non-homogenous Poisson process

rxPp(10, 1 / 10, prob = function(x) {
  1/(1+abs(x))
})

}
\author{
Matthew Fidler
}
