% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxrandom.R
\name{rxbeta}
\alias{rxbeta}
\title{Simulate beta variable from threefry generator}
\usage{
rxbeta(shape1, shape2, n = 1L, ncores = 1L)
}
\arguments{
\item{shape1, shape2}{non-negative parameters of the Beta distribution.}

\item{n}{number of observations. If \code{length(n) > 1}, the length
    is taken to be the number required.}

\item{ncores}{Number of cores for the simulation

\code{rxnorm} simulates using the threefry sitmo generator;}
}
\value{
beta random deviates
}
\description{
Care should be taken with this method not to encounter the
birthday problem, described
\url{https://www.johndcook.com/blog/2016/01/29/random-number-generator-seed-mistakes/}.
Since the \code{sitmo} \code{threefry}, this currently generates
one random deviate from the uniform distribution to seed the
engine \code{threefry} and then run the code.
}
\details{
Therefore, a simple call to the random number generated followed by a second
call to random number generated may have identical seeds.  As the number of
random number generator calls are increased the probability that the
birthday problem will increase.

The key to avoid this problem is to either run all simulations in the
\code{rxode2} environment once (therefore one seed or series of seeds
for the whole simulation), pre-generate all random variables
used for the simulation, or seed the rxode2 engine with \code{rxSetSeed()}

Internally each ID is seeded with a unique number so that the
results do not depend on the number of cores used.
}
\examples{
## Use threefry engine

rxbeta(0.5, 0.5, n = 10) # with rxbeta you have to explicitly state n
rxbeta(5, 1, n = 10, ncores = 2) # You can parallelize the simulation using openMP

rxbeta(1, 3)
}
